/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.feedback;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.table.TableCellEditor;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.PopupSelectFileColumnFormat;
import ordermate.database.feedback.FeedbackAck;
import ordermate.database.feedback.FeedbackAnswer;
import ordermate.database.feedback.FeedbackQuestion;
import ordermate.database.users.AllPermissions;
import ordermate.gui.model.NullableEventComboBoxModel;
import ordermate.reports.table.ColumnFormat;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;

public class AnswersState
extends AbstractEditableTableState<FeedbackAnswer> {
    private EventList<FeedbackAck> allAcks;
    private EventComboBoxModel<FeedbackAck> acksModel;
    private EventList<FeedbackQuestion> allQuestions;
    private NullableEventComboBoxModel questionModel;
    private EventList<FeedbackQuestion> questionList;
    private AnswersSearcher searcher;

    public AnswersState() {
        super("Answers", AllPermissions.GOD_ONLY, "Possible answers to a question");
    }

    @Override
    protected ObjectEditor<FeedbackAnswer> createObjectEditor() {
        return null;
    }

    @Override
    protected OfficeMateObjectSearch<FeedbackAnswer> createSearchPanelFactory() {
        this.questionList = new BasicEventList();
        this.searcher = new AnswersSearcher();
        ObjectPropertySearch<FeedbackAnswer> search = new ObjectPropertySearch<FeedbackAnswer>(FeedbackAnswer.class, (ObjectQuerySearcher<FeedbackAnswer>)this.searcher, (EventList<FeedbackAnswer>)new BasicEventList());
        RefreshAction refresh = new RefreshAction(search);
        search.addSearchField((SearchGuiField)new ComboSearchField("Question:", this.searcher.getQuestionFilter(), false, (Action)refresh, this.questionList));
        return search;
    }

    @Override
    public String getTypeName() {
        return "Answer";
    }

    @Override
    protected TableStateCentralArea<FeedbackAnswer> createCentralArea() {
        this.allAcks = new BasicEventList();
        this.acksModel = new EventComboBoxModel(this.allAcks);
        JComboBox<FeedbackAck> acksBox = new JComboBox<FeedbackAck>((ComboBoxModel<FeedbackAck>)this.acksModel);
        this.allQuestions = new BasicEventList();
        this.questionModel = new NullableEventComboBoxModel(this.allQuestions);
        JComboBox questionBox = new JComboBox(this.questionModel);
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new EditablePropertyColumnFormat(FeedbackAnswer.Properties.LABEL), new EditablePropertyColumnFormat(FeedbackAnswer.Properties.ANSWER_TEXT), new EditablePropertyColumnFormat(FeedbackAnswer.Properties.SEQUENCE), new PopupSelectFileColumnFormat("Icon", (PropertyAccessor)FeedbackAnswer.Properties.ICON, "*.jpg, *.png", "jpg", "png"), new EditablePropertyColumnFormat(FeedbackAnswer.Properties.FEEDBACK_ACK).setCustomEditor((TableCellEditor)new ComboBoxCellEditor(acksBox)), new EditablePropertyColumnFormat(FeedbackAnswer.Properties.NEXT_QUESTION).setCustomEditor((TableCellEditor)new ComboBoxCellEditor(questionBox))});
        PersistentObjectTable<FeedbackAnswer> table = new PersistentObjectTable<FeedbackAnswer>(this.getObjectList(), format);
        return table;
    }

    @Override
    public void onStart() {
        this.questionList.getReadWriteLock().writeLock().lock();
        this.questionList.clear();
        this.questionList.addAll((Collection)PersistenceManager.getObjectList(FeedbackQuestion.class, (String)Query.select(FeedbackQuestion.class).active(FeedbackQuestion.class).toString(), null));
        this.questionList.getReadWriteLock().writeLock().unlock();
        this.allAcks.getReadWriteLock().writeLock().lock();
        this.allAcks.clear();
        this.allAcks.addAll((Collection)PersistenceManager.getObjectList(FeedbackAck.class, (String)Query.select(FeedbackAck.class).active(FeedbackAck.class).toString()));
        this.allAcks.getReadWriteLock().writeLock().unlock();
        this.allQuestions.getReadWriteLock().writeLock().lock();
        this.allQuestions.clear();
        this.allQuestions.addAll((Collection)PersistenceManager.getObjectList(FeedbackQuestion.class, (String)Query.select(FeedbackQuestion.class).active(FeedbackQuestion.class).toString(), null));
        this.allQuestions.getReadWriteLock().writeLock().unlock();
        this.questionModel.prependNullPlaceholder(this.allQuestions);
        super.onStart();
    }

    @Override
    protected FeedbackAnswer createNewObject() {
        FeedbackQuestion question = (FeedbackQuestion)this.searcher.getQuestionFilter().getSearchValue();
        if (question == null) {
            Dialogs.showErrorDialog("Cannot Create Answer", "You must have a question before you create an answer.");
            return null;
        }
        if (question.isPayAtTable() && question.getAnswers().size() >= 5) {
            Dialogs.showErrorDialog("Cannot Create Answer", "A Pay At Table Question cannot have more than 5 answers.");
            return null;
        }
        return new FeedbackAnswer(question);
    }

    @Override
    protected Class<FeedbackAnswer> getDisplayingType() {
        return FeedbackAnswer.class;
    }

    @Override
    public void refresh() {
        super.refresh();
        this.questionModel.prependNullPlaceholder(this.allQuestions);
    }

    class AnswersSearcher
    extends PropertySearcher<FeedbackAnswer> {
        private ISingleValueSearchFilter<FeedbackQuestion> questionFilter;

        public AnswersSearcher() {
            super(FeedbackAnswer.class);
            this.questionFilter = new ObjectSearchFilter(FeedbackAnswer.Properties.PARENT_QUESTION);
            this.addSearchFilter((SearchFilterI)this.questionFilter);
        }

        ISingleValueSearchFilter<FeedbackQuestion> getQuestionFilter() {
            return this.questionFilter;
        }

        public ObjectQuery getBaseQuery() {
            ObjectQuery query = Query.select(FeedbackAnswer.class).active(FeedbackAnswer.class);
            return query;
        }
    }
}

