/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.giftvoucher;

import au.com.ordermate.gui.renderer.StringifierListCellRenderer;
import au.com.ordermate.util.CharCaseStringifier;
import au.com.ordermate.util.StringCharCase;
import au.com.ordermate.util.Stringifier;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import officemate.components.AbstractObjectEditor;
import officemate.screens.setup.configuration.webservice.ConfigurableWebserviceConfigSetupEditor;
import ordermate.database.integration.giftvoucher.GiftVoucherConfiguration;
import ordermate.database.integration.giftvoucher.GiftVoucherCreationStrategy;
import ordermate.database.integration.giftvoucher.GiftVoucherIntegrationType;
import ordermate.database.integration.giftvoucher.VoucherPrintingStrategy;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.VoucherPrefixValidator;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Validator;

class GiftVoucherConfigurationEditor
extends AbstractObjectEditor<GiftVoucherConfiguration> {
    private List<JComponent> unmodifiables;
    private JLabel lastAuth;
    private JLabel lastVoucher;
    private JLabel integrationType;
    private final int DEFAULT_EXPIRY_PERIOD = 1095;
    private ConfigurableWebserviceConfigSetupEditor webEditor;
    private List<JComponent> localOnly = new ArrayList<JComponent>();

    GiftVoucherConfigurationEditor() {
        this.getBindings().setStrategy(AutoBinding.UpdateStrategy.READ_WRITE);
        this.unmodifiables = new ArrayList<JComponent>();
        this.setupComponents();
    }

    private void setupComponents() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.integrationType = new JLabel();
        builder.addRow("Scheme Type", (Component)this.integrationType);
        JComponent comp = this.setupTextField(GiftVoucherConfiguration.Properties.LABEL, 20);
        this.localOnly.add(comp);
        builder.addRow("Label", (Component)comp);
        comp = this.setupIntSpinner(GiftVoucherConfiguration.Properties.DEFAULT_EXPIRY_PERIOD, 10, 1095, Integer.MAX_VALUE, 1095, 5);
        this.localOnly.add(comp);
        builder.addRow("Expiry Period (Days)", (Component)comp);
        comp = this.setupComboBox(GiftVoucherConfiguration.Properties.CREATION_STRATEGY, GlazedLists.eventListOf((Object[])GiftVoucherCreationStrategy.values()));
        this.localOnly.add(comp);
        builder.addRow("Create Unknown Voucher", (Component)comp);
        JComboBox voucherPrintStrategyCombo = this.setupComboBox(GiftVoucherConfiguration.Properties.PRINTING, GlazedLists.eventListOf((Object[])VoucherPrintingStrategy.values()));
        voucherPrintStrategyCombo.setRenderer(new StringifierListCellRenderer((Stringifier)new CharCaseStringifier(StringCharCase.All_Upper)));
        builder.addRow("Print Docket", (Component)voucherPrintStrategyCombo);
        this.getBindings().setStrategy(AutoBinding.UpdateStrategy.READ_ONCE);
        this.lastVoucher = new JLabel();
        builder.addRow("Last Voucher", (Component)this.lastVoucher);
        this.lastAuth = new JLabel();
        builder.addRow("Last Auth", (Component)this.lastAuth);
        this.getBindings().setStrategy(AutoBinding.UpdateStrategy.READ_WRITE);
        builder.addSeparator("Unmodifiable Once Used");
        comp = this.setupTextField(GiftVoucherConfiguration.Properties.PREFIX, 5, (Validator)new VoucherPrefixValidator());
        builder.addRow("Prefix", (Component)comp);
        this.unmodifiables.add(comp);
        comp = this.setupCheckBox(GiftVoucherConfiguration.Properties.AUTO_GEN);
        builder.addRow("Auto Generate", (Component)comp);
        this.unmodifiables.add(comp);
        comp = this.setupIntSpinner(GiftVoucherConfiguration.Properties.UUID_LENGTH, 1, 6, 64, 20, 5);
        builder.addRow("Voucher Code Length", (Component)comp);
        this.unmodifiables.add(comp);
        comp = this.setupIntSpinner(GiftVoucherConfiguration.Properties.TIMEOUT, 1, 1, 120, 10, 5);
        builder.addRow("Lock Timeout (seconds)", (Component)comp);
        this.unmodifiables.add(comp);
        this.add(builder.getPanel());
        this.webEditor = new ConfigurableWebserviceConfigSetupEditor();
        this.add(this.webEditor);
    }

    @Override
    public void setObject(GiftVoucherConfiguration config) {
        super.setObject(config);
        this.integrationType.setText(config.getIntegrationType().getLabel());
        this.lastAuth.setText(config.getLastAuthId());
        this.lastVoucher.setText(String.valueOf(config.getLastVoucherId()).replace("null", "None"));
        boolean local = GiftVoucherIntegrationType.POS.equals((Object)config.getIntegrationType());
        boolean canModify = config.getLastVoucherId() == null && local;
        for (JComponent comp : this.unmodifiables) {
            comp.setEnabled(canModify);
        }
        for (JComponent comp : this.localOnly) {
            comp.setEnabled(local);
        }
        if (!local) {
            this.webEditor.setObject(config.getWebConfig());
            this.buildWebEditor(config);
            this.webEditor.setVisible(true);
        } else {
            this.webEditor.setVisible(false);
            this.webEditor.setObject(null);
        }
    }

    @Override
    public void saveObject() {
        this.webEditor.saveObject();
        super.saveObject();
    }

    private void buildWebEditor(GiftVoucherConfiguration config) {
        if (!this.webEditor.isBuilt()) {
            // empty if block
        }
    }
}

