/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.giftvoucher;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.JTextComponent;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.AbstractObjectEditor;
import officemate.components.EditorDialog;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.setup.configuration.giftvoucher.GiftVoucherConfigurationEditor;
import ordermate.OrderMate;
import ordermate.database.finance.giftvoucher.VoucherUtils;
import ordermate.database.integration.giftvoucher.GiftVoucherConfiguration;
import ordermate.database.integration.giftvoucher.GiftVoucherCreationStrategy;
import ordermate.database.integration.giftvoucher.GiftVoucherIntegrationType;
import ordermate.database.users.Permission;
import ordermate.integration.voucher.VoucherExporter;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import ordermate.services.misc.CallMethodOnClassExecutable;

public class GiftVoucherConfigurationSetupState
extends AbstractEditableTableState<GiftVoucherConfiguration> {
    private AbstractAction syncChanges;
    private AbstractAction exportVouchers;
    public static final String TITLE_NO_LOCAL_SCHEME_SELECTED = "No Local Scheme Selected";
    public static final String TITLE_PUSH_CHANGES_WARNING = "Push Changes";
    public static final String TITLE_SUCCESSFUL_EXPORT = "Vouchers Successfully Exported";
    public static final String MSG_NO_LOCAL_SCHEME_SELECTED = "Please select a Local(POS) scheme before exporting";
    public static final String MSG_PUSH_CHANGES_WARNING = "Please ensure that no one is using vouchers before pressing OK";
    public static final String MSG_SUCCESSFUL_EXPORT = "Vouchers exported successfully.";

    public GiftVoucherConfigurationSetupState(Permission permission) {
        super("Voucher Schemes", permission, "Configure Voucher Schemes");
    }

    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        this.getCentralArea().getTable().setName("GiftVoucherConfigTable");
        this.syncChanges = new SyncLocalAction("Update Schemes", IconLoader.get((String)"/officemate/images/resync.png"));
        this.addAction(this.syncChanges);
        this.exportVouchers = new VoucherExportAction("Export to CSV", IconLoader.get((String)"/ordermate/images/exportMissing.png"));
        this.addAction(this.exportVouchers);
    }

    @Override
    protected AbstractObjectEditor<GiftVoucherConfiguration> createObjectEditor() {
        return new GiftVoucherConfigurationEditor();
    }

    @Override
    public String getTypeName() {
        return "Voucher Configuration";
    }

    @Override
    public GiftVoucherConfiguration createNewObject() {
        return new GiftVoucherConfiguration(GiftVoucherIntegrationType.POS);
    }

    @Override
    protected EditorDialog createEditorDialog() {
        EditorDialog dialog = super.createEditorDialog();
        dialog.setResizable(false);
        return dialog;
    }

    @Override
    protected OfficeMateObjectSearch<GiftVoucherConfiguration> createSearchPanelFactory() {
        PropertySearcher<GiftVoucherConfiguration> searcher = new PropertySearcher<GiftVoucherConfiguration>(GiftVoucherConfiguration.class){

            protected ObjectQuery getBaseQuery() {
                return Query.select(GiftVoucherConfiguration.class).active(GiftVoucherConfiguration.class);
            }
        };
        ObjectPropertySearch<GiftVoucherConfiguration> search = new ObjectPropertySearch<GiftVoucherConfiguration>(GiftVoucherConfiguration.class, (ObjectQuerySearcher<GiftVoucherConfiguration>)searcher, (EventList<GiftVoucherConfiguration>)new BasicEventList());
        return search;
    }

    @Override
    protected TableStateCentralArea<GiftVoucherConfiguration> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat();
        format.addColumn((ColumnFormat)new PropertyColumnFormat(GiftVoucherConfiguration.Properties.LABEL));
        format.addColumn((ColumnFormat)new PropertyColumnFormat("Integration Type", GiftVoucherConfiguration.Properties.INTEGRATION_TYPE));
        JComboBox<Object> strategyComboBox = new JComboBox<Object>((ComboBoxModel<Object>)new EventComboBoxModel(GlazedLists.eventListOf((Object[])GiftVoucherCreationStrategy.values())));
        strategyComboBox.setRenderer(new VoucherCreationStrategyComboRenderer());
        format.addColumn((ColumnFormat)new PropertyColumnFormat("Creation Strategy", GiftVoucherConfiguration.Properties.CREATION_STRATEGY));
        format.addColumn((ColumnFormat)new PropertyColumnFormat("Code Prefix", GiftVoucherConfiguration.Properties.PREFIX));
        format.addColumn((ColumnFormat)new PropertyColumnFormat("Code Length", GiftVoucherConfiguration.Properties.UUID_LENGTH));
        format.addColumn((ColumnFormat)new PropertyColumnFormat("Timeout (seconds)", GiftVoucherConfiguration.Properties.TIMEOUT));
        format.addColumn((ColumnFormat)new PropertyColumnFormat("Active", GiftVoucherConfiguration.Properties.SYSTEM_STATE));
        format.addColumn((ColumnFormat)new PropertyColumnFormat("Auto-Generating", GiftVoucherConfiguration.Properties.AUTO_GEN));
        format.addColumn((ColumnFormat)new PropertyColumnFormat("Last Auth ID", GiftVoucherConfiguration.Properties.LAST_AUTH_ID));
        format.addColumn((ColumnFormat)new PropertyColumnFormat("Expiry Period (Days)", GiftVoucherConfiguration.Properties.DEFAULT_EXPIRY_PERIOD));
        PersistentObjectTable<GiftVoucherConfiguration> configTable = new PersistentObjectTable<GiftVoucherConfiguration>(this.getObjectList(), format);
        return configTable;
    }

    @Override
    protected Class<GiftVoucherConfiguration> getDisplayingType() {
        return GiftVoucherConfiguration.class;
    }

    @Override
    protected boolean isValidForSaving() {
        return !VoucherUtils.hasClashingPrefix((GiftVoucherConfiguration)((GiftVoucherConfiguration)this.getObjectEditor().getObject()));
    }

    @Override
    protected void showCannotSaveDialog() {
        Dialogs.showErrorDialog("Clashing Voucher Prefixes", "Cannot save voucher scheme because it clashes with another voucher prefix.\nMake sure prefixes are unique and/or does not clash with another.");
    }

    private boolean showPushChangesWarning() {
        return Dialogs.showChoiceDialog(TITLE_PUSH_CHANGES_WARNING, MSG_PUSH_CHANGES_WARNING);
    }

    private GiftVoucherConfiguration getSelectedScheme() {
        GiftVoucherConfiguration selectedScheme = (GiftVoucherConfiguration)this.getCentralArea().getSelectedObject();
        if (selectedScheme == null || !GiftVoucherIntegrationType.POS.equals((Object)selectedScheme.getIntegrationType())) {
            Dialogs.showInfoDialog(TITLE_NO_LOCAL_SCHEME_SELECTED, MSG_NO_LOCAL_SCHEME_SELECTED);
        }
        return selectedScheme;
    }

    private class VoucherExportAction
    extends AbstractAction {
        public VoucherExportAction(String name, ImageIcon icon) {
            super(name, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GiftVoucherConfiguration selectedScheme;
            if (GiftVoucherConfigurationSetupState.this.showPushChangesWarning() && (selectedScheme = GiftVoucherConfigurationSetupState.this.getSelectedScheme()) != null) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileFilter(new FileNameExtensionFilter("CSV Files", "csv"));
                try {
                    int responseVal = chooser.showSaveDialog(GiftVoucherConfigurationSetupState.this.getScreenPanel());
                    if (responseVal == 0) {
                        File file = chooser.getSelectedFile();
                        if (!file.getName().contains(".")) {
                            file = new File(file.getAbsolutePath() + ".csv");
                        }
                        VoucherExporter exporter = new VoucherExporter(selectedScheme);
                        exporter.export((Writer)new FileWriter(file));
                        Dialogs.showMessageDialog(GiftVoucherConfigurationSetupState.TITLE_SUCCESSFUL_EXPORT, GiftVoucherConfigurationSetupState.MSG_SUCCESSFUL_EXPORT);
                    }
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("Cannot export vouchers of the scheme " + selectedScheme, (Throwable)ex);
                    Dialogs.showWarningDialog("Cannot export vouchers of the scheme", "There was an error exporting the vouchers of scheme, please see the logs.");
                }
            }
        }
    }

    private class SyncLocalAction
    extends AbstractAction {
        SyncLocalAction(String name, Icon icon) {
            super(name, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GiftVoucherConfigurationSetupState.this.showPushChangesWarning()) {
                CallMethodOnClassExecutable exec = new CallMethodOnClassExecutable("servermate.services.voucher.ServermateVoucherAdministrator", new String[]{"getInstance", "init"});
                PersistenceManager.getServerConnection().runSync((Executable)exec);
            }
        }
    }

    class VoucherCreationStrategyComboRenderer
    extends DefaultListCellRenderer {
        VoucherCreationStrategyComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            GiftVoucherCreationStrategy strategy = (GiftVoucherCreationStrategy)value;
            if (comp instanceof JLabel) {
                ((JLabel)comp).setText(strategy.getDescription());
            } else if (comp instanceof JTextComponent) {
                ((JTextComponent)comp).setText(strategy.getDescription());
            }
            return comp;
        }
    }

    class VoucherCreationStrategyRenderer
    extends DefaultTableCellRenderer {
        VoucherCreationStrategyRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            GiftVoucherCreationStrategy strategy = (GiftVoucherCreationStrategy)value;
            if (comp instanceof JLabel) {
                ((JLabel)comp).setText(strategy.getDescription());
            } else if (comp instanceof JTextComponent) {
                ((JTextComponent)comp).setText(strategy.getDescription());
            }
            return comp;
        }
    }
}

