/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.integrations;

import au.com.ordermate.xmlintegration.omni.OmniBackRequirement;
import au.com.ordermate.xmlintegration.omni.OmniBackRequirements;
import com.sun.jersey.api.client.ClientResponse;
import javax.swing.JOptionPane;
import officemate.adminkit.dialogs.Dialogs;
import ordermate.OrderMate;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.integration.cloudback.CloudIntegrationUtil;

public class CloudRequirementsAction {
    private final CloudBackConfig cloudConfig;

    public CloudRequirementsAction(CloudBackConfig config) {
        this.cloudConfig = config;
    }

    public void gotEdit(OmniBackRequirements theReqs) {
        for (OmniBackRequirement req : theReqs.getRequirements()) {
            String input;
            String label = "Provide " + req.getLabel();
            if (Boolean.TRUE.equals(req.isRequired())) {
                label = label + " (Required)";
            }
            if ((input = JOptionPane.showInputDialog(null, req.getDescription(), label)) == null) {
                return;
            }
            req.setValue(input);
        }
        this.sendDetails(theReqs);
    }

    private void sendDetails(OmniBackRequirements reqs) {
        ClientResponse response = CloudIntegrationUtil.postRequirements((CloudBackConfig)this.cloudConfig, (long)SystemCurrentInfo.getInstance().getRedbackId(), (OmniBackRequirements)reqs);
        String entity = (String)response.getEntity(String.class);
        if (response.getStatus() / 100 == 2) {
            OmniBackRequirements updatedReqs = CloudIntegrationUtil.parseRequirements((String)entity);
            StringBuilder SB = new StringBuilder("<html>" + this.cloudConfig.getCloudServerType() + " Config for ").append(updatedReqs.getTypeValue()).append("<br><ol>");
            for (OmniBackRequirement req : updatedReqs.getRequirements()) {
                SB.append("<li>").append(req.getLabel()).append(": ").append(req.getValue()).append("</li>");
            }
            SB.append("</ol><br>");
            SB.append("has been set successfully.<br><br>");
            SB.append("</b></html>");
            OrderMate.LOG.info(SB.toString());
            Dialogs.showInfoDialog(this.cloudConfig.getCloudServerType() + " Configuration Successful", SB.toString());
        } else {
            OrderMate.LOG.error("Problem setting online config at " + this.cloudConfig.getCloudServerType() + " " + response.getStatus() + " " + entity);
            Dialogs.showWarningDialog(this.cloudConfig.getCloudServerType() + " Error", this.cloudConfig.getCloudServerType() + " failed to respond. Please check logs.");
        }
    }
}

