/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.integrations;

import au.com.ordermate.xmlintegration.omni.OmniBackRequirements;
import au.com.ordermate.xmlintegration.omni.OmniBackRequirementsType;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.setup.configuration.advanced.cloudback.CloudMenuAction;
import officemate.screens.setup.configuration.integrations.CloudRequirementsAction;
import officemate.screens.setup.configuration.integrations.PosIntegrationSummarySearch;
import ordermate.OrderMate;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.integration.cloudback.CloudServerType;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.users.AllPermissions;
import ordermate.integration.cloudback.CloudIntegrationUtil;
import ordermate.integration.types.PosIntegrationSummary;
import ordermate.integration.types.PosIntegrationType;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class PosIntegrationsState
extends AbstractTableState<PosIntegrationSummary> {
    public PosIntegrationsState() {
        super("Integrations", AllPermissions.ACCESS_PERMISSIONS_SCREEN, "View your integrations");
    }

    @Override
    protected OfficeMateObjectSearch<PosIntegrationSummary> createSearchPanelFactory() {
        return new PosIntegrationSummarySearch((EventList<PosIntegrationSummary>)new BasicEventList());
    }

    @Override
    public boolean supportsEdit() {
        return true;
    }

    @Override
    public void doEditAction() {
        PosIntegrationSummary selected = (PosIntegrationSummary)this.getCentralArea().getSelectedObject();
        if (selected != null) {
            if (PosIntegrationType.OnlineOrders.equals((Object)selected.getType())) {
                new CloudMenuAction().gotType((OmniBackRequirementsType)selected.getData());
            } else {
                CloudBackConfig config = null;
                if (!PosIntegrationType.Vouchers.equals((Object)selected.getType())) {
                    Dialogs.showMessageDialog("Unable to configure", "No configuration is possible for this item");
                    OrderMate.LOG.error("Developers are reponsible for making sure the cloud config is configured for " + selected.getType());
                    return;
                }
                config = CloudBackConfig.getCloudBackConfig((CloudServerType)CloudServerType.Hive);
                OmniBackRequirements reqs = CloudIntegrationUtil.getRequirementsForType((CloudBackConfig)config, (long)SystemCurrentInfo.getInstance().getRedbackId(), (OmniBackRequirementsType)((OmniBackRequirementsType)selected.getData()));
                new CloudRequirementsAction(config).gotEdit(reqs);
            }
        }
    }

    @Override
    protected TableStateCentralArea<PosIntegrationSummary> createCentralArea() {
        ColumnTableFormat cols = new ColumnTableFormat();
        cols.addColumn((ColumnFormat)new PropertyColumnFormat(PosIntegrationSummary.Properties.TYPE));
        cols.addColumn((ColumnFormat)new PropertyColumnFormat(PosIntegrationSummary.Properties.LABEL));
        cols.addColumn((ColumnFormat)new PropertyColumnFormat(PosIntegrationSummary.Properties.DESC));
        cols.addColumn((ColumnFormat)new PropertyColumnFormat(PosIntegrationSummary.Properties.ACTIVE));
        cols.addColumn((ColumnFormat)new PropertyColumnFormat(PosIntegrationSummary.Properties.LAST_USED));
        cols.addColumn((ColumnFormat)new PropertyColumnFormat(PosIntegrationSummary.Properties.INFO));
        PersistentObjectTable<PosIntegrationSummary> summaryTable = new PersistentObjectTable<PosIntegrationSummary>(this.getObjectList(), cols);
        return summaryTable;
    }

    @Override
    protected Class<PosIntegrationSummary> getDisplayingType() {
        return PosIntegrationSummary.class;
    }
}

