/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.internationalization;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.table.TableCellEditor;
import officemate.components.AbstractObjectEditor;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import ordermate.database.internationalization.ConfigInternationalization;
import ordermate.database.users.AllPermissions;
import ordermate.gui.FieldPanelBuilder;
import ordermate.internationalization.Internationalization;
import ordermate.reports.table.ColumnFormat;

public class InternationalizationState
extends AbstractEditableTableState<ConfigInternationalization> {
    public InternationalizationState() {
        super("Internationalization", AllPermissions.ORDERMATE_PROPERTIES, "Language- and Resourcebundle configuration.");
        this.setSmallIcon(IconLoader.get((String)"/officemate/images/locale16.png"));
    }

    @Override
    protected ObjectEditor<ConfigInternationalization> createObjectEditor() {
        return new AbstractObjectEditor<ConfigInternationalization>(){

            @Override
            protected void init() {
                FieldPanelBuilder builder = new FieldPanelBuilder();
                builder.addRow("Name", (Component)this.setupTextField(ConfigInternationalization.Properties.NAME, 20));
                builder.addRow("Money Locale", (Component)this.setupComboBox(ConfigInternationalization.Properties.LOCALE_MONEY, GlazedLists.eventList((Collection)Internationalization.getAllAvailableLocalesAsStringValues())));
                builder.addRow("Language Locale", (Component)this.setupComboBox(ConfigInternationalization.Properties.LOCALE_LANGUAGE, GlazedLists.eventList((Collection)Internationalization.getAllAvailableLocalesAsStringValues())));
                builder.addRow("State Locale", (Component)this.setupComboBox(ConfigInternationalization.Properties.LOCALE_STATES, GlazedLists.eventList((Collection)Internationalization.getAllAvailableLocalesAsStringValues())));
                builder.addRow("active", (Component)this.setupCheckBox(ConfigInternationalization.Properties.ACTIVE));
                this.add(builder.getPanel());
            }
        };
    }

    @Override
    public String getTypeName() {
        return "Internationalization";
    }

    @Override
    protected TableStateCentralArea<ConfigInternationalization> createCentralArea() {
        List allAvailableLocales = Internationalization.getAllAvailableLocalesAsStringValues();
        EventList moneyLocales = GlazedLists.eventList((Collection)allAvailableLocales);
        EventList languageLocales = GlazedLists.eventList((Collection)allAvailableLocales);
        EventList statesLocales = GlazedLists.eventList((Collection)allAvailableLocales);
        AutoCompleteComboCellEditor moneyLocalesEditor = new AutoCompleteComboCellEditor(moneyLocales);
        AutoCompleteComboCellEditor languagesLocalesEditor = new AutoCompleteComboCellEditor(languageLocales);
        AutoCompleteComboCellEditor statesLocalesEditor = new AutoCompleteComboCellEditor(statesLocales);
        PersistentObjectTable<ConfigInternationalization> table = new PersistentObjectTable<ConfigInternationalization>(this.getObjectList(), new ColumnTableFormat(new ColumnFormat[]{new EditablePropertyColumnFormat("Name", ConfigInternationalization.Properties.NAME), new EditablePropertyColumnFormat("Money Locale", ConfigInternationalization.Properties.LOCALE_MONEY).setCustomEditor((TableCellEditor)((Object)moneyLocalesEditor)), new EditablePropertyColumnFormat("Language Locale", ConfigInternationalization.Properties.LOCALE_LANGUAGE).setCustomEditor((TableCellEditor)((Object)languagesLocalesEditor)), new EditablePropertyColumnFormat("State Locale", ConfigInternationalization.Properties.LOCALE_STATES).setCustomEditor((TableCellEditor)((Object)statesLocalesEditor)), new EditablePropertyColumnFormat("Active", ConfigInternationalization.Properties.ACTIVE)}));
        return table;
    }

    @Override
    protected Class<ConfigInternationalization> getDisplayingType() {
        return ConfigInternationalization.class;
    }

    @Override
    public void gotObjectEdited(ConfigInternationalization editedObject) {
        super.gotObjectEdited(editedObject);
        this.refresh();
    }
}

