/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.invoices;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.components.AbstractObjectEditor;
import ordermate.database.integration.InvoiceIntegrationConfig;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockSupplier;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.FileExistsValidator;
import ordermate.gui.binding.validators.NotEmptyValidator;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Validator;

public class InvoiceIntegrationObjectEditor
extends AbstractObjectEditor<InvoiceIntegrationConfig> {
    private final EventList<StockArea> stockAreas = GlazedLists.eventList((Collection)StockArea.getStockAreas());
    private final EventList<StockSupplier> suppliers = GlazedLists.eventList((Collection)StockSupplier.getSuppliers());
    private JLabel typeLabel;

    public InvoiceIntegrationObjectEditor() {
        this.getBindings().setStrategy(AutoBinding.UpdateStrategy.READ_WRITE);
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.typeLabel = new JLabel();
        builder.addRow("Integration Type:", (Component)this.typeLabel);
        JTextField custNo = this.setupTextField(InvoiceIntegrationConfig.Properties.CUSTOMER_NO, 10, (Validator)new NotEmptyValidator());
        builder.addRow("Customer No", (Component)custNo);
        JComboBox stockAreaCombo = this.setupComboBox(InvoiceIntegrationConfig.Properties.STOCK_AREA, this.stockAreas);
        builder.addRow("Default Stock Area", (Component)stockAreaCombo);
        JComboBox supplierCombo = this.setupComboBox(InvoiceIntegrationConfig.Properties.SUPPLIER, this.suppliers);
        builder.addRow("Default Supplier", (Component)supplierCombo);
        JTextField filePath = this.setupTextField(InvoiceIntegrationConfig.Properties.DEFAULT_FILE_PATH, 50, (Validator)new FileExistsValidator(true, false));
        builder.addRow("Default File Path", (Component)filePath);
        this.add(builder.getPanel());
    }

    @Override
    public void setObject(InvoiceIntegrationConfig config) {
        super.setObject(config);
        this.typeLabel.setText(config.getType().name());
    }

    @Override
    public void refresh() {
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.stockAreas, StockArea.getStockAreas());
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.suppliers, StockSupplier.getSuppliers());
    }
}

