/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.invoices;

import au.com.ordermate.gui.ObjectEditor;
import java.util.Arrays;
import java.util.List;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.setup.configuration.invoices.InvoiceIntegrationObjectEditor;
import ordermate.database.integration.InvoiceIntegrationConfig;
import ordermate.database.users.AllPermissions;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class InvoiceIntegrationSetupState
extends AbstractEditableTableState<InvoiceIntegrationConfig> {
    public InvoiceIntegrationSetupState() {
        super("Invoice Integration", AllPermissions.CONFIG_INTEGRATIONS, "Config the invoice integration");
    }

    @Override
    protected ObjectEditor<InvoiceIntegrationConfig> createObjectEditor() {
        return new InvoiceIntegrationObjectEditor();
    }

    @Override
    public String getTypeName() {
        return "Invoice Integration";
    }

    @Override
    protected TableStateCentralArea<InvoiceIntegrationConfig> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(InvoiceIntegrationConfig.Properties.TYPE), new PropertyColumnFormat(InvoiceIntegrationConfig.Properties.STOCK_AREA).setName("Default Stock Area"), new PropertyColumnFormat(InvoiceIntegrationConfig.Properties.DEFAULT_FILE_PATH), new PropertyColumnFormat(InvoiceIntegrationConfig.Properties.CUSTOMER_NO)});
        PersistentObjectTable<InvoiceIntegrationConfig> table = new PersistentObjectTable<InvoiceIntegrationConfig>(this.getObjectList(), format);
        return table;
    }

    @Override
    protected Class<InvoiceIntegrationConfig> getDisplayingType() {
        return InvoiceIntegrationConfig.class;
    }

    @Override
    public InvoiceIntegrationConfig createNewObject() {
        List<InvoiceIntegrationConfig.InvoiceIntegrationType> types = Arrays.asList(InvoiceIntegrationConfig.InvoiceIntegrationType.values());
        InvoiceIntegrationConfig.InvoiceIntegrationType type = (InvoiceIntegrationConfig.InvoiceIntegrationType)Dialogs.showOptionDialog("New Invoice Integration", "Please select a new invoice integration type.", types);
        if (type == null) {
            return null;
        }
        InvoiceIntegrationConfig config = InvoiceIntegrationConfig.getConfigForType((InvoiceIntegrationConfig.InvoiceIntegrationType)type);
        if (config.isPersistent()) {
            Dialogs.showWarningDialog("Integration Already Exists", "An integration configuration for " + type + " already exists.");
            return null;
        }
        return config;
    }
}

