/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.locations;

import au.com.ordermate.gui.ObjectEditor;
import ca.odell.glazedlists.EventList;
import java.util.List;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.users.AllPermissions;
import ordermate.reports.table.ColumnFormat;

public class SalesLocationState
extends AbstractEditableTableState<SalesLocation> {
    public static final String MSG_CANNOT_DELETE_SALES_LOCATION = "You must have at least one Sales Location!";

    public SalesLocationState() {
        super("Sales Locations", AllPermissions.LOCATIONS, "View, add and configure Sales Locations");
    }

    @Override
    protected ObjectEditor<SalesLocation> createObjectEditor() {
        return null;
    }

    @Override
    public String getTypeName() {
        return "Sales Location";
    }

    @Override
    protected TableStateCentralArea<SalesLocation> createCentralArea() {
        PersistentObjectTable<SalesLocation> table = new PersistentObjectTable<SalesLocation>(this.getObjectList(), new ColumnTableFormat(new ColumnFormat[]{new EditablePropertyColumnFormat("Name", SalesLocation.Properties.LABEL)}));
        return table;
    }

    @Override
    protected Class<SalesLocation> getDisplayingType() {
        return SalesLocation.class;
    }

    @Override
    public EventList<SalesLocation> getObjectList() {
        this.setFilterActive(true);
        return super.getObjectList();
    }

    @Override
    public void gotObjectEdited(SalesLocation editedObject) {
        super.gotObjectEdited(editedObject);
        this.refresh();
    }

    @Override
    protected boolean isDeleteAllowed(List<SalesLocation> toDelete) {
        List currentActiveSalesLocations = SalesLocation.getSalesLocations();
        if (currentActiveSalesLocations.size() <= toDelete.size()) {
            String title = "Cannot Delete Sales Location";
            Dialogs.showErrorDialog("Cannot Delete Sales Location", MSG_CANNOT_DELETE_SALES_LOCATION);
            return false;
        }
        return super.isDeleteAllowed(toDelete);
    }
}

