/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.loyalty;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.components.AbstractObjectEditor;
import officemate.screens.setup.configuration.loyalty.IntegrationExternalIDTable;
import ordermate.database.integration.AbstractIntegrationExtID;
import ordermate.database.integration.IntegrationExtIDHelper;
import ordermate.database.integration.LoyaltyIntegrationConfig;
import ordermate.database.integration.TerminalIntegrationExtID;
import ordermate.database.integration.UserIntegrationExtID;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.LoyaltyType;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.NotEmptyValidator;
import ordermate.gui.binding.validators.PositiveIntValidator;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Validator;

class LoyaltyIntegrationEditor
extends AbstractObjectEditor<LoyaltyIntegrationConfig>
implements ActionListener {
    private JComboBox integrationType;
    private JTextField serverIPAddress;
    private JTextField serverPort;
    private JTextField accessKey;
    private JTextField defaultTerminal;
    private JTextField username;
    private JTextField password;
    private JTextField defaultAttendant;
    private JTextField memberNumberLength;
    private List<JComponent> igtComps;
    private List<JComponent> tracComps;
    private EventList<TerminalIntegrationExtID> terminalList;
    private EventList<UserIntegrationExtID> userList;

    public LoyaltyIntegrationEditor() {
        this.setLayout(new FlowLayout(0));
        this.getBindings().setStrategy(AutoBinding.UpdateStrategy.READ_WRITE);
        this.igtComps = new ArrayList<JComponent>();
        this.tracComps = new ArrayList<JComponent>();
        this.terminalList = GlazedLists.eventList((Collection)IntegrationExtIDHelper.getAllExtIDFor(TerminalIntegrationExtID.class, (AbstractIntegrationExtID.IntegrationExtIDType)AbstractIntegrationExtID.IntegrationExtIDType.IGT, (boolean)true));
        this.userList = GlazedLists.eventList((Collection)IntegrationExtIDHelper.getAllExtIDFor(UserIntegrationExtID.class, (AbstractIntegrationExtID.IntegrationExtIDType)AbstractIntegrationExtID.IntegrationExtIDType.IGT, (boolean)true));
        this.setupComponents();
    }

    private void setupComponents() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.integrationType = this.setupComboBox(LoyaltyIntegrationConfig.Properties.TYPE, new DefaultComboBoxModel<LoyaltyIntegrationConfig.LoyaltyIntegrationType>(new LoyaltyIntegrationConfig.LoyaltyIntegrationType[]{LoyaltyIntegrationConfig.LoyaltyIntegrationType.HO, LoyaltyIntegrationConfig.LoyaltyIntegrationType.IGT, LoyaltyIntegrationConfig.LoyaltyIntegrationType.TRAC}), (Validator)new NotEmptyValidator());
        this.integrationType.addActionListener(this);
        builder.addRow("Integration Type", (Component)this.integrationType);
        builder.addRow("Can Modify Ratios", (Component)this.setupCheckBox(LoyaltyIntegrationConfig.Properties.CAN_MODIFY_RATIOS));
        this.serverIPAddress = this.setupTextField(LoyaltyIntegrationConfig.Properties.SERVER_IP_ADDRESS, 24);
        builder.addRow("Server IP Address", (Component)this.serverIPAddress);
        this.serverPort = this.setupIntegerField(LoyaltyIntegrationConfig.Properties.SERVER_PORT, 6, (Validator)new PositiveIntValidator(true, false));
        builder.addRow("Server Port", (Component)this.serverPort);
        this.accessKey = this.setupTextField(LoyaltyIntegrationConfig.Properties.ACCESS_KEY, 24);
        builder.addRow("Access Key", (Component)this.accessKey);
        this.defaultTerminal = this.setupTextField(LoyaltyIntegrationConfig.Properties.DEFAULT_TERMINAL, 24);
        builder.addRow("Default Terminal", (Component)this.defaultTerminal);
        this.defaultAttendant = this.setupTextField(LoyaltyIntegrationConfig.Properties.DEFAULT_ATTENDANT, 24);
        builder.addRow("Default Attendant", (Component)this.defaultAttendant);
        this.username = this.setupTextField(LoyaltyIntegrationConfig.Properties.USERNAME, 24);
        builder.addRow("Trac Username", (Component)this.username);
        this.password = this.setupTextField(LoyaltyIntegrationConfig.Properties.PASSWORD, 24);
        builder.addRow("Trac Password", (Component)this.password);
        this.memberNumberLength = this.setupIntegerField(LoyaltyIntegrationConfig.Properties.MEMBER_NUMBER_LENGTH, 6, (Validator)new PositiveIntValidator(false, false));
        this.memberNumberLength.setToolTipText("Sets the number of digits that will be considered a member number. eg: 4 = XXXX");
        builder.addRow("Member Number Length", (Component)this.memberNumberLength);
        this.igtComps.add(this.serverIPAddress);
        this.igtComps.add(this.serverPort);
        this.igtComps.add(this.accessKey);
        this.igtComps.add(this.defaultTerminal);
        this.igtComps.add(this.defaultAttendant);
        this.igtComps.add(this.memberNumberLength);
        this.tracComps.add(this.serverIPAddress);
        this.tracComps.add(this.username);
        this.tracComps.add(this.password);
        builder.addSeparator("External IDs");
        builder.addRow("", (Component)this.setupExternalIDTabPane());
        this.add(builder.getPanel());
    }

    private JComponent setupExternalIDTabPane() {
        JTabbedPane extIDTabPane = new JTabbedPane();
        IntegrationExternalIDTable<TerminalIntegrationExtID> termExtIDTable = new IntegrationExternalIDTable<TerminalIntegrationExtID>(this.terminalList);
        termExtIDTable.objectEdited().connect((Object)this, "gotObjectEdited");
        extIDTabPane.addTab("Terminal", termExtIDTable);
        IntegrationExternalIDTable<UserIntegrationExtID> userExtIDTable = new IntegrationExternalIDTable<UserIntegrationExtID>(this.userList);
        userExtIDTable.objectEdited().connect((Object)this, "gotObjectEdited");
        extIDTabPane.addTab("User", userExtIDTable);
        this.igtComps.add(extIDTabPane);
        this.igtComps.add((JComponent)termExtIDTable.getTable());
        this.igtComps.add((JComponent)userExtIDTable.getTable());
        return extIDTabPane;
    }

    private void setCompsEnabled(boolean enabled, List<JComponent> comps) {
        for (JComponent comp : comps) {
            comp.setEnabled(enabled);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.integrationType) {
            if (this.integrationType.getSelectedItem().equals(LoyaltyIntegrationConfig.LoyaltyIntegrationType.IGT)) {
                this.setCompsEnabled(false, this.tracComps);
                this.setCompsEnabled(true, this.igtComps);
            } else if (this.integrationType.getSelectedItem().equals(LoyaltyIntegrationConfig.LoyaltyIntegrationType.TRAC)) {
                this.setCompsEnabled(false, this.igtComps);
                this.setCompsEnabled(true, this.tracComps);
            } else if (this.integrationType.getSelectedItem().equals(LoyaltyIntegrationConfig.LoyaltyIntegrationType.HO)) {
                this.setCompsEnabled(false, this.igtComps);
                this.setCompsEnabled(false, this.tracComps);
            }
        }
    }

    private void gotObjectEdited() {
        this.objectEdited.emit();
    }

    void save() {
        if (LoyaltyIntegrationConfig.getInstance().getType().equals((Object)LoyaltyIntegrationConfig.LoyaltyIntegrationType.IGT)) {
            SystemProperty sysProp = SystemProperty.getInstance();
            sysProp.setLoyaltyPointsType(LoyaltyType.POINTS);
            sysProp.save();
        }
        IntegrationExtIDHelper.saveAndDelete(this.terminalList);
        IntegrationExtIDHelper.saveAndDelete(this.userList);
        this.refreshExternalIDLists();
    }

    void cancel() {
        LoyaltyIntegrationConfig.collapseReference();
        this.refreshExternalIDLists();
    }

    private void refreshExternalIDLists() {
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.terminalList, (List)GlazedLists.eventList((Collection)IntegrationExtIDHelper.getAllExtIDFor(TerminalIntegrationExtID.class, (AbstractIntegrationExtID.IntegrationExtIDType)AbstractIntegrationExtID.IntegrationExtIDType.IGT, (boolean)true)));
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.userList, (List)GlazedLists.eventList((Collection)IntegrationExtIDHelper.getAllExtIDFor(UserIntegrationExtID.class, (AbstractIntegrationExtID.IntegrationExtIDType)AbstractIntegrationExtID.IntegrationExtIDType.IGT, (boolean)true)));
    }
}

