/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.menulog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import officemate.components.AbstractObjectEditor;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.integration.online.PrintOnlyOnlineTerminalConfiguration;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.FileExistsValidator;
import ordermate.gui.binding.validators.PositiveIntValidator;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Validator;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;

public class PrintOnlyOnlineConfigurationEditor
extends AbstractObjectEditor<PrintOnlyOnlineTerminalConfiguration>
implements ActionListener {
    private List<Terminal> terminals = new ArrayList<Terminal>(Terminal.getAllWaiterMateTerminals());
    private List<VirtualPrinter> printers = new ArrayList<VirtualPrinter>(VirtualPrinter.getAllPrinters());
    private String directory = "";
    private JFileChooser editor;
    private final Object editorGuard = new Object();
    private JTextField directoryField;

    public PrintOnlyOnlineConfigurationEditor() {
        this.setLayout(new BorderLayout());
        FieldPanelBuilder builder = new FieldPanelBuilder();
        JButton button = new JButton("Choose dockets directory");
        button.addActionListener(this);
        builder.addRow("", (Component)button);
        this.directoryField = new JTextField(50);
        Binding filePathBinding = this.getBindings().createBinding(PrintOnlyOnlineTerminalConfiguration.Properties.FILE_PATH, (Object)this.directoryField, "text");
        builder.addRow("Directory", (Component)this.directoryField);
        filePathBinding.setValidator((Validator)new FileExistsValidator(true, false));
        JComboBox<Object> terminalsBox = new JComboBox<Object>(this.terminals.toArray());
        AutoCompleteDecorator.decorate(terminalsBox);
        Binding terminalBinding = this.getBindings().createJComboBoxBinding(PrintOnlyOnlineTerminalConfiguration.Properties.TERMINAL, terminalsBox, this.terminals);
        builder.addRow("Terminals :", terminalsBox);
        terminalBinding.refresh();
        JComboBox printersBox = new JComboBox();
        AutoCompleteDecorator.decorate(printersBox);
        Binding printerBinding = this.getBindings().createJComboBoxBinding(PrintOnlyOnlineTerminalConfiguration.Properties.VIRTUAL_PRINTER, printersBox, this.printers);
        builder.addRow("Printers :", printersBox);
        JSpinner menulogHeight = new JSpinner();
        Binding heightBinding = this.getBindings().createIntegerBinding(PrintOnlyOnlineTerminalConfiguration.Properties.MENULOG_HEIGHT, menulogHeight, 0, 400, 0);
        heightBinding.setValidator((Validator)new PositiveIntValidator(true));
        builder.addRow("MenuLog panel height", (Component)menulogHeight);
        this.add(builder.getPanel());
    }

    private JFileChooser getEditor() {
        if (this.editor == null) {
            this.editor = new JFileChooser();
            this.editor.setFileSelectionMode(1);
        }
        return this.editor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser theEditor = this.getEditor();
        theEditor.setMultiSelectionEnabled(false);
        theEditor.setLocation(this.getLocation());
        int r = theEditor.showDialog(this, "Ok");
        if (r == 0) {
            this.directory = theEditor.getSelectedFile().getPath();
            this.directoryField.setText(this.directory);
            this.directoryField.repaint();
        }
    }

    @Override
    public void setObject(PrintOnlyOnlineTerminalConfiguration obj) {
        ArrayList localTerminals = new ArrayList(Terminal.getAllWaiterMateTerminals());
        this.terminals.retainAll(Terminal.getAllWaiterMateTerminals());
        localTerminals.removeAll(this.terminals);
        this.terminals.addAll(localTerminals);
        if (obj != null && obj.getTerminal() == null && !this.terminals.isEmpty()) {
            obj.setTerminal(this.terminals.get(0));
        }
        this.printers.clear();
        this.printers.addAll(VirtualPrinter.getAllPrinters());
        super.setObject(obj);
    }
}

