/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.onlineintegration;

import java.awt.Component;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.AbstractObjectEditor;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.setup.configuration.onlineintegration.OnlineIntegrationObjectEditor;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.integration.online.OnlineAccountSource;
import ordermate.database.integration.online.OnlineIntegrationConfig;
import ordermate.database.users.AllPermissions;
import ordermate.reports.table.AbstractColumnFormat;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class OnlineConfigurationSetupState
extends AbstractEditableTableState<OnlineIntegrationConfig> {
    public OnlineConfigurationSetupState() {
        super("Online Integration", AllPermissions.CONFIG_INTEGRATIONS, "Configure online integrations");
        OnlineIntegrationConfig.getDefaultInstance();
    }

    @Override
    protected AbstractObjectEditor<OnlineIntegrationConfig> createObjectEditor() {
        return new OnlineIntegrationObjectEditor();
    }

    @Override
    public String getTypeName() {
        return "Online Integration";
    }

    @Override
    public void doDelete(List<OnlineIntegrationConfig> toDelete) {
        for (OnlineIntegrationConfig config : toDelete) {
            if (!OnlineIntegrationConfig.getDefaultInstance().equals((Object)config)) continue;
            Dialogs.showInfoDialog("Cannot Delete", "The Default Integration cannot be deleted");
            return;
        }
        super.doDelete(toDelete);
    }

    @Override
    public OnlineIntegrationConfig createNewObject() {
        OnlineIntegrationConfig config = new OnlineIntegrationConfig(OnlineAccountSource.I_TAKEAWAY.getSourceName(), OnlineIntegrationConfig.getDefaultInstance());
        return config;
    }

    @Override
    protected TableStateCentralArea<OnlineIntegrationConfig> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(OnlineIntegrationConfig.Properties.LABEL), new PropertyColumnFormat(OnlineIntegrationConfig.Properties.INVENTORY_PROFILE), new PropertyColumnFormat(OnlineIntegrationConfig.Properties.PRINTING_STRATEGY).setCustomRenderer((TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                ((DefaultTableCellRenderer)comp).setText(((OnlineIntegrationConfig.PrintingStrategy)value).getLabel());
                return comp;
            }
        }), new AbstractColumnFormat("Pre-payment", String.class){

            public Object resolveColumnValue(Object baseObject) {
                OnlineIntegrationConfig config = (OnlineIntegrationConfig)baseObject;
                StringBuilder SB = new StringBuilder();
                if (OnlineIntegrationConfig.PrePaymentMethod.ADD_PAYMENT_TYPE.equals((Object)config.getPrePaymentMethod())) {
                    SB.append("Pay with type ");
                    FinanceUnit unit = config.getPayOffFinanceUnit();
                    if (unit == null) {
                        SB.append("default web unit");
                    } else {
                        SB.append(unit.getLabel());
                    }
                } else {
                    SB.append("Pay to debtor ");
                    if (config.getPayOffDebtor() == null) {
                        SB.append("Default");
                    } else {
                        SB.append(config.getPayOffDebtor().getLabel());
                    }
                }
                return SB.toString();
            }
        }});
        PersistentObjectTable<OnlineIntegrationConfig> table = new PersistentObjectTable<OnlineIntegrationConfig>(this.getObjectList(), format);
        return table;
    }

    @Override
    protected Class<OnlineIntegrationConfig> getDisplayingType() {
        return OnlineIntegrationConfig.class;
    }
}

