/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.onlineintegration;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateTimeUtils;
import java.awt.Component;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import officemate.components.AbstractObjectEditor;
import ordermate.database.misc.WebResourceLog;
import ordermate.database.misc.WebResourceLogExt;
import ordermate.gui.FieldPanelBuilder;

public class WebResourceLogEditor
extends AbstractObjectEditor<WebResourceLog> {
    private JTextArea reqField;
    private JTextArea respField;
    private JTextField dateField;

    WebResourceLogEditor() {
        this.setupComponents();
    }

    private void setupComponents() {
        this.setLayout(new BoxLayout(this, 1));
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.dateField = new JTextField();
        builder.addRow("Date & Time", (Component)this.dateField);
        builder.addRow("Method", (Component)this.setupTextField(WebResourceLog.Properties.HTTP_METHOD, 20));
        this.add(builder.getPanel());
        this.add(new JLabel("Request"));
        this.reqField = new JTextArea(4, 100);
        this.add(new JScrollPane(this.reqField));
        this.add(new JLabel("Response"));
        this.respField = new JTextArea(4, 100);
        this.add(new JScrollPane(this.respField));
    }

    @Override
    public void setObject(WebResourceLog object) {
        super.setObject(object);
        if (object.getCreationDateTime() == null) {
            this.dateField.setText(DateTimeUtils.combineDateAndTime((Date)object.getCreationDate(), (Date)object.getCreationTime()).toString());
        } else {
            this.dateField.setText(object.getCreationDateTime());
        }
        WebResourceLogExt ext = (WebResourceLogExt)PersistenceManager.getObject(WebResourceLogExt.class, (String)Query.select(WebResourceLogExt.class).equals(WebResourceLogExt.Properties.WEB_RESOURCE_LOG, (Object)object).toString());
        if (ext != null) {
            this.reqField.setText(ext.getRequestBody());
            this.respField.setText(ext.getResponseBody());
        } else {
            this.reqField.setText(null);
            this.respField.setText(null);
        }
    }

    @Override
    public void saveObject() {
    }
}

