/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.opay;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import ca.odell.glazedlists.GlazedLists;
import java.util.Collection;
import java.util.List;
import javax.swing.table.TableCellEditor;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import ordermate.database.hardware.eftpos.EftposType;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.integration.opay.OpaySettingsConfig;
import ordermate.reports.table.ColumnFormat;

public class OpaySettingsConfigState
extends AbstractEditableTableState<OpaySettingsConfig> {
    @Override
    public void doNewAction() {
        List terminals = PersistenceManager.getObjectList(VirtualEftpos.class, (String)Query.select(VirtualEftpos.class).active(VirtualEftpos.class).equals(VirtualEftpos.Properties.EFTPOS_TYPE, (Object)EftposType.ADYEN).toString());
        if (terminals.isEmpty()) {
            return;
        }
        List cashdrawers = PersistenceManager.getObjectList(CashDrawer.class, (String)Query.select(CashDrawer.class).active(CashDrawer.class).toString());
        OpaySettingsConfig lastCreated = new OpaySettingsConfig();
        lastCreated.setEftpos((VirtualEftpos)terminals.get(0));
        lastCreated.setSplitBillEnabled(true);
        lastCreated.setItemSplitEnabled(true);
        lastCreated.setPatronSplitEnabled(true);
        lastCreated.setTippingEnabled(true);
        lastCreated.save();
        this.refresh();
    }

    public OpaySettingsConfigState() {
        super("Opay Settings", null, "Set up defaults for Opay terminals");
    }

    @Override
    protected ObjectEditor<OpaySettingsConfig> createObjectEditor() {
        return null;
    }

    @Override
    public String getTypeName() {
        return "Opay Settings";
    }

    private CashDrawer addNullCD() {
        CashDrawer c = new CashDrawer();
        c.setLabel("<Default>");
        return c;
    }

    @Override
    protected TableStateCentralArea<OpaySettingsConfig> createCentralArea() {
        EditablePropertyColumnFormat format = new EditablePropertyColumnFormat("Terminal", OpaySettingsConfig.Properties.EFTPOS);
        List terminals = PersistenceManager.getObjectList(VirtualEftpos.class, (String)Query.select(VirtualEftpos.class).active(VirtualEftpos.class).equals(VirtualEftpos.Properties.EFTPOS_TYPE, (Object)EftposType.ADYEN).toString());
        format.setCustomEditor((TableCellEditor)((Object)this.createAutoCompleteEditor(terminals)));
        EditablePropertyColumnFormat formatCd = new EditablePropertyColumnFormat("Cashdrawer", OpaySettingsConfig.Properties.CASHDRAWER);
        List cashdrawers = PersistenceManager.getObjectList(CashDrawer.class, (String)Query.select(CashDrawer.class).active(CashDrawer.class).toString());
        formatCd.setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(GlazedLists.eventList((Collection)cashdrawers), true)));
        PersistentObjectTable<OpaySettingsConfig> table = new PersistentObjectTable<OpaySettingsConfig>(this.getObjectList(), new ColumnTableFormat(new ColumnFormat[]{format, new EditablePropertyColumnFormat("Patron Split Enabled", OpaySettingsConfig.Properties.PATRON_SPLIT_ENABLED), new EditablePropertyColumnFormat("Item Split Enabled", OpaySettingsConfig.Properties.ITEM_SPLIT_ENABLED), new EditablePropertyColumnFormat("Split Bill Enabled", OpaySettingsConfig.Properties.SPLIT_BILL_ENABLED), new EditablePropertyColumnFormat("Tipping Enabled", OpaySettingsConfig.Properties.TIPPING_ENABLED), formatCd}));
        return table;
    }

    private AutoCompleteComboCellEditor createAutoCompleteEditor(Collection<?> list) {
        return new AutoCompleteComboCellEditor(GlazedLists.eventList(list), false);
    }

    @Override
    protected Class<OpaySettingsConfig> getDisplayingType() {
        return OpaySettingsConfig.class;
    }
}

