/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.opay;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import ca.odell.glazedlists.GlazedLists;
import java.util.Collection;
import java.util.List;
import javax.swing.table.TableCellEditor;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import ordermate.database.hardware.eftpos.EftposType;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.integration.opay.OpayTippingConfig;
import ordermate.reports.table.ColumnFormat;

public class OpayTippingConfigState
extends AbstractEditableTableState<OpayTippingConfig> {
    @Override
    public void doNewAction() {
        List terminals = PersistenceManager.getObjectList(VirtualEftpos.class, (String)Query.select(VirtualEftpos.class).active(VirtualEftpos.class).equals(VirtualEftpos.Properties.EFTPOS_TYPE, (Object)EftposType.ADYEN).toString());
        if (terminals.isEmpty()) {
            return;
        }
        OpayTippingConfig lastCreated = new OpayTippingConfig();
        lastCreated.setEftpos((VirtualEftpos)terminals.get(0));
        lastCreated.setTippingDefaultFirst(5.0);
        lastCreated.setTippingDefaultSecond(10.0);
        lastCreated.setTippingDefaultThird(15.0);
        lastCreated.setTippingDefaultFirstLine("Good");
        lastCreated.setTippingDefaultSecondLine("Great");
        lastCreated.setTippingDefaultThirdLine("Amazing");
        lastCreated.save();
        this.refresh();
    }

    public OpayTippingConfigState() {
        super("Opay Tipping Defaults", null, "Set up defaults for tipping for Opay terminals");
    }

    @Override
    protected ObjectEditor<OpayTippingConfig> createObjectEditor() {
        return null;
    }

    @Override
    public String getTypeName() {
        return "Opay Tipping Defaults";
    }

    @Override
    protected TableStateCentralArea<OpayTippingConfig> createCentralArea() {
        EditablePropertyColumnFormat format = new EditablePropertyColumnFormat("Terminal", OpayTippingConfig.Properties.EFTPOS);
        List terminals = PersistenceManager.getObjectList(VirtualEftpos.class, (String)Query.select(VirtualEftpos.class).active(VirtualEftpos.class).equals(VirtualEftpos.Properties.EFTPOS_TYPE, (Object)EftposType.ADYEN).toString());
        format.setCustomEditor((TableCellEditor)((Object)this.createAutoCompleteEditor(terminals)));
        PersistentObjectTable<OpayTippingConfig> table = new PersistentObjectTable<OpayTippingConfig>(this.getObjectList(), new ColumnTableFormat(new ColumnFormat[]{format, new EditablePropertyColumnFormat("First Tip Amount", OpayTippingConfig.Properties.TIPPING_DEFAULT_FIRST), new EditablePropertyColumnFormat("First Tip Prompt", OpayTippingConfig.Properties.TIPPING_DEFAULT_FIRST_LINE), new EditablePropertyColumnFormat("Second Tip Amount", OpayTippingConfig.Properties.TIPPING_DEFAULT_SECOND), new EditablePropertyColumnFormat("Second Tip Prompt", OpayTippingConfig.Properties.TIPPING_DEFAULT_SECOND_LINE), new EditablePropertyColumnFormat("Third Tip Amount", OpayTippingConfig.Properties.TIPPING_DEFAULT_THIRD), new EditablePropertyColumnFormat("Third Tip Prompt", OpayTippingConfig.Properties.TIPPING_DEFAULT_THIRD_LINE)}));
        return table;
    }

    private AutoCompleteComboCellEditor createAutoCompleteEditor(Collection<?> list) {
        return new AutoCompleteComboCellEditor(GlazedLists.eventList(list), false);
    }

    @Override
    protected Class<OpayTippingConfig> getDisplayingType() {
        return OpayTippingConfig.class;
    }
}

