/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.printergroup;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.List;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.strategy.AuditableInstantSaveStrategy;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.users.AllPermissions;
import ordermate.reports.table.ColumnFormat;

public class PrinterGroupState
extends AbstractEditableTableState<PrinterGroup> {
    public PrinterGroupState() {
        super("Printer Groups", AllPermissions.EDIT_PRINTER_GROUPS, "Add, Edit and Remove PrinterGroups.");
        AuditableInstantSaveStrategy strategy = new AuditableInstantSaveStrategy();
        this.setSaveStrategy(strategy);
    }

    @Override
    protected ObjectEditor<PrinterGroup> createObjectEditor() {
        return null;
    }

    @Override
    public String getTypeName() {
        return "Printer Group";
    }

    @Override
    protected TableStateCentralArea<PrinterGroup> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new EditablePropertyColumnFormat(PrinterGroup.Properties.LABEL)});
        PersistentObjectTable<PrinterGroup> table = new PersistentObjectTable<PrinterGroup>(this.getObjectList(), format);
        return table;
    }

    @Override
    public void doDelete(List<PrinterGroup> toDelete) {
        for (PrinterGroup nextGroup : toDelete) {
            List<InventoryItem> linkedItems = this.getLinkedItems(nextGroup);
            if (linkedItems.isEmpty()) continue;
            StringBuilder SB = new StringBuilder("<html>The printer group ");
            SB.append(nextGroup.getLabel()).append(" is still linked to one or more items.<ul>");
            for (int i = 0; i < linkedItems.size(); ++i) {
                SB.append("<li>").append(linkedItems.get(i).getLabel()).append("</li>");
                if (i <= 2) continue;
                SB.append("<li>...</li>");
                break;
            }
            SB.append("</ul>Please change the Printer Group for these items before deleting.</html>");
            Dialogs.showWarningDialog("Linked Printer Group", SB.toString());
            return;
        }
        super.doDelete(toDelete);
    }

    private List<InventoryItem> getLinkedItems(PrinterGroup group) {
        ObjectQuery query = Query.select(InventoryItem.class).equals(InventoryItem.Properties.PRINTER_GROUP, (Object)group).active(InventoryItem.class).limit(4);
        return PersistenceManager.getObjectList(InventoryItem.class, (String)query.toString());
    }

    @Override
    protected Class<PrinterGroup> getDisplayingType() {
        return PrinterGroup.class;
    }
}

