/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.printing;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.dockets.HtmlCommander;
import au.com.ordermate.dockets.PrintCommanderInterface;
import au.com.ordermate.dockets.XMLDocketScanner;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.StringReader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import officemate.OfficeMate;
import officemate.adminkit.dialogs.OkCancelDialogBuilder;
import officemate.components.AbstractObjectEditor;
import officemate.screens.setup.configuration.printing.DocketTemplateLinesViewer;
import officemate.screens.setup.configuration.printing.ReplaceTextPanel;
import ordermate.database.docket.DocketTemplate;
import ordermate.database.docket.TemplateLine;
import ordermate.database.finance.Shift;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.reports.CashDrawerTakingsSummary;
import ordermate.database.finance.reports.RestaurantTakingsSummary;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.hardware.physical.PhysicalPrinter;
import ordermate.database.hardware.physical.kts.KTSDocketDataSummary;
import ordermate.database.inventory.coupon.InventoryCoupon;
import ordermate.database.inventory.coupon.PriceAdjustmentCoupon;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.Course;
import ordermate.database.queries.sales.DeliveryQueries;
import ordermate.database.queries.stock.StockRequisitionOrderQueries;
import ordermate.database.sales.Account;
import ordermate.database.sales.Delivery;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.sales.coupon.SalesCoupon;
import ordermate.database.stock.requisition.StockRequisitionOrder;
import ordermate.database.users.User;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.docketprocessor.GroovyDocket;
import ordermate.docketprocessor.SimplePrintJob;
import ordermate.dockets.groovy.XmlDocket;

public class DocketTemplateLinesEditor
extends AbstractObjectEditor<DocketTemplate> {
    private DocketTemplateLinesViewer viewer = new DocketTemplateLinesViewer();
    private DocketTemplate template;
    private HtmlCommander buffer = new HtmlCommander(48);
    private XMLDocketScanner scanner = new XMLDocketScanner((PrintCommanderInterface)this.buffer);
    private String receiptXMLFile;
    private String prepXMLFile;
    private Account account;
    private Map<String, TemplateLine> lines = new HashMap<String, TemplateLine>();
    private Object[] params;
    private TemplateLine templateLine = null;
    private List lastAccounts;
    private int accountIndex;
    private String firstPasse;
    private String secondPasse;
    private boolean transfer;
    private List collector = new ArrayList();

    public DocketTemplateLinesEditor() {
        this.setLayout(new BorderLayout());
        this.adjustSize();
        this.add((Component)this.viewer, "Center");
        this.getModelAccount();
        this.viewer.nameSelected.connect((Object)this, "gotNameSelected");
        this.viewer.alignChanged.connect((Object)this, "gotAlignChanged");
        this.viewer.colorChanged.connect((Object)this, "gotColorChanged");
        this.viewer.visibleChanged.connect((Object)this, "gotVisibleChanged");
        this.viewer.weightChanged.connect((Object)this, "gotWeightChanged");
        this.viewer.underlineChanged.connect((Object)this, "gotUnderlineChanged");
        this.viewer.invertedChanged.connect((Object)this, "gotInvertedChanged");
        this.viewer.replaceText.connect((Object)this, "gotReplaceText");
        this.viewer.mustRefresh.connect((Object)this, "gotRefresh");
        this.viewer.printPreviewDocket.connect((Object)this, "printPreviewDocket");
        this.viewer.showNotVisibleChanged.connect((Object)this, "gotShowNotVisibleChanged");
        this.viewer.hourFormatChanged.connect((Object)this, "gotHourFormatChanged");
        this.viewer.accountTypeChanged.connect((Object)this, "gotAccountTypeChanged");
        this.viewer.printerChanged.connect((Object)this, "gotPrinterChanged");
        this.viewer.terminalChanged.connect((Object)this, "gotTerminalChanged");
        this.viewer.previous.connect((Object)this, "gotPrevious");
        this.viewer.next.connect((Object)this, "gotNext");
        this.viewer.displayXmlResult.connect((Object)this, "gotDisplayXmlResult");
        this.viewer.transferChanged.connect((Object)this, "gotTransferChanged");
        this.viewer.setViewHourFormat(BusinessInfo.getInstance().getDocketHourFormat());
    }

    @Override
    public void setObject(DocketTemplate toEdit) {
        super.setObject(toEdit);
        this.template = (DocketTemplate)this.getObject();
        DocketTemplate.DocketType type = this.template.getType();
        if (type.equals((Object)DocketTemplate.DocketType.PREP_DOCKET)) {
            this.retrieveParamsForPrepDocket();
        } else if (type.equals((Object)DocketTemplate.DocketType.TAKINGS_DOCKET)) {
            this.retrieveParamsForTakingsDocket();
        } else if (type.equals((Object)DocketTemplate.DocketType.RECEIPT)) {
            this.retrieveParamsForReceipt();
        } else if (type.equals((Object)DocketTemplate.DocketType.TAKINGS_ALL_CASHDRAWER_DOCKET)) {
            this.retrieveParamsForTakingsDocket();
        } else if (type.equals((Object)DocketTemplate.DocketType.DRIVER_SUMMARY)) {
            this.retrieveParamsForDriverSummary();
        } else if (type.equals((Object)DocketTemplate.DocketType.KTS_REPORT_DOCKET)) {
            this.retrieveParamsForKTSSummary();
        } else if (type.equals((Object)DocketTemplate.DocketType.COURSE_DOCKET)) {
            this.retrieveParamsForCourseDocket();
        } else if (type.equals((Object)DocketTemplate.DocketType.LABOUR_REPORT_DOCKET) || type.equals((Object)DocketTemplate.DocketType.ACCOUNT_SALES_REPORT_DOCKET)) {
            this.retrieveParamsForWMSummary();
        } else if (type.equals((Object)DocketTemplate.DocketType.STOCK_REQ_TEMPLATE)) {
            this.retrieveParamsForStockReqDocket();
        } else if (type.equals((Object)DocketTemplate.DocketType.VOUCHER_DOCKET)) {
            this.retrieveParamsForVoucher();
        } else if (type.equals((Object)DocketTemplate.DocketType.COUPON_DOCKET)) {
            this.retrieveParamsForCoupon();
        } else {
            throw new IllegalArgumentException("Unknown type of docket : " + this.template.getType());
        }
        this.getModelAccount();
        this.refreshView();
    }

    private void retrieveParamsForDriverSummary() {
        List deliveries = PersistenceManager.getObjectList(Delivery.class, (String)Query.select(Delivery.class).active(Delivery.class).orderByDesc(Delivery.Properties.TIME_CREATED).limit(100).toString(), null);
        Delivery foundDeliveryWithAccounts = null;
        for (Delivery del : deliveries) {
            if (del.getAccounts().size() <= 0) continue;
            foundDeliveryWithAccounts = del;
        }
        if (foundDeliveryWithAccounts == null) {
            return;
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(foundDeliveryWithAccounts.getDriver());
        Shift start = ((PhoneAccount)foundDeliveryWithAccounts.getAccounts().get(0)).getShift();
        Shift end = ((PhoneAccount)foundDeliveryWithAccounts.getAccounts().get(0)).getShift();
        paramList.add(start);
        paramList.add(end);
        paramList.add(PersistenceManager.getObjectList(Delivery.class, (String)DeliveryQueries.getDeliveriesForShift((User)foundDeliveryWithAccounts.getDriver(), (Shift)start, (Shift)end).toString()));
        this.params = paramList.toArray();
    }

    void gotNameSelected(String name) {
        if (name != null) {
            this.templateLine = this.lines.get(name);
            if (this.templateLine == null) {
                this.templateLine = new TemplateLine(name);
                this.lines.put(name, this.templateLine);
            }
            this.setViewAttributeAlign(this.templateLine.getAlign());
            this.setViewAttributeColor(this.templateLine.getColor());
            this.setViewAttributeVisible(this.templateLine.getVisible());
            this.setViewAttributeWeight(this.templateLine.getWeight());
            this.setViewAttributeUnderline(this.templateLine.getUnderline());
            this.setViewAttributeInverted(this.templateLine.getInverted());
            this.setViewAttributeReplace(this.templateLine.getReplace());
        } else {
            this.templateLine = null;
        }
    }

    void gotAlignChanged(String align) {
        this.templateLine.setAlign(align);
    }

    void gotColorChanged(String color) {
        this.templateLine.setColor(color);
    }

    void gotVisibleChanged(String visible) {
        this.templateLine.setVisible(visible);
    }

    void gotUnderlineChanged(String option) {
        this.templateLine.setUnderline(option);
    }

    void gotInvertedChanged(Boolean option) {
        this.templateLine.setInverted(String.valueOf(option));
    }

    void gotWeightChanged(String weight) {
        this.templateLine.setWeight(weight);
    }

    void gotReplaceText() {
        ReplaceTextPanel panel = new ReplaceTextPanel();
        panel.setText(this.templateLine.getReplace());
        OkCancelDialogBuilder builder = new OkCancelDialogBuilder(panel);
        if (builder.doShow()) {
            this.templateLine.setReplace(panel.getText());
        }
    }

    void gotRefresh() {
        this.refreshView();
    }

    private String createPrintPreviewDocket() {
        StringBuilder sb = new StringBuilder();
        try {
            StringReader stringReader = new StringReader(this.firstPasse);
            String lineSeparator = System.getProperty("line.separator");
            String blankLine = "<line />";
            BufferedReader bufferedReader = new BufferedReader(stringReader);
            String line = bufferedReader.readLine();
            sb.append(line);
            sb.append(lineSeparator);
            sb.append("<line align='center' color='BLACK' weight='big'>NOT TO BE USED</line>");
            sb.append(lineSeparator);
            sb.append(blankLine);
            sb.append(lineSeparator);
            sb.append("<line align='center' color='BLACK' weight='big'>TEST PRINT ONLY</line>");
            sb.append(lineSeparator);
            sb.append(blankLine);
            sb.append(lineSeparator);
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
                sb.append(System.getProperty("line.separator"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sb.toString();
    }

    void printPreviewDocket() {
        String docketContent = this.createPrintPreviewDocket();
        ArrayList<VirtualPrinter> singlePrinterList = new ArrayList<VirtualPrinter>();
        VirtualPrinter virtualPrinter = this.viewer.getSelectedPrinter();
        PhysicalPrinter physicalPrinter = (PhysicalPrinter)virtualPrinter.getPrintDevice();
        singlePrinterList.add(this.viewer.getSelectedPrinter());
        try {
            DocketProcessor.connect((InetAddress)Terminal.getServerMateTerminal().getAddress(), (int)11100);
            DocketProcessor.printSimpleDocket((SimplePrintJob)new SimplePrintJob(docketContent, singlePrinterList, true));
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            JFrame guiFrame = GuiApp.getAppComplex().getApplicationFrame().getFrame();
            JOptionPane.showMessageDialog(guiFrame, "Problem with the print : " + ioe.getMessage(), "Error", 0);
        }
    }

    void gotShowNotVisibleChanged(Boolean b) {
        this.scanner.setIgnoreVisible(b.booleanValue());
        this.refreshView();
    }

    void gotHourFormatChanged(String format) {
        BusinessInfo.getInstance().setDocketHourFormat(format);
    }

    void gotAccountTypeChanged() {
        this.getModelAccount();
        this.refreshView();
    }

    void gotPrinterChanged() {
        Terminal selectedTerminal = this.viewer.getSelectedTerminal();
        this.receiptXMLFile = this.viewer.getSelectedPrinter().getReceiptXMLFile(selectedTerminal);
        this.prepXMLFile = this.viewer.getSelectedPrinter().getPrepDocketFile();
        this.buffer = new HtmlCommander(((PhysicalPrinter)this.viewer.getSelectedPrinter().getPrintDevice()).getWidth());
        this.scanner = new XMLDocketScanner((PrintCommanderInterface)this.buffer);
        this.refreshView();
    }

    void gotTerminalChanged() {
        this.refreshView();
    }

    void gotTransferChanged(Boolean selection) {
        this.transfer = selection;
        this.refreshView();
    }

    void gotNext() {
        if (this.lastAccounts != null && this.accountIndex > 0) {
            this.account = (Account)this.lastAccounts.get(--this.accountIndex);
        }
        this.refreshView();
    }

    void gotPrevious() {
        if (this.lastAccounts != null && this.accountIndex < this.lastAccounts.size() - 1) {
            this.account = (Account)this.lastAccounts.get(++this.accountIndex);
            this.refreshView();
        }
    }

    void gotDisplayXmlResult(String type) {
        if (type.equals("xml")) {
            this.viewer.setTextView(this.firstPasse);
        } else {
            this.viewer.setTextView(this.secondPasse);
        }
    }

    void refreshView() {
        if (this.account == null) {
            this.viewer.setView("<html><body><h1>Cannot find an account for the type " + this.viewer.getSelectedAccountType() + " in last shift.</h1></body></html>");
        } else {
            this.buffer.clear();
            this.collector.clear();
            XmlDocket docket = this.getDocket();
            this.firstPasse = docket.generateXml();
            try {
                this.secondPasse = this.scanner.visitDocument(this.firstPasse, false);
            }
            catch (Exception ex) {
                this.secondPasse = ex.getLocalizedMessage();
                OfficeMate.LOG.error((Object)ex);
            }
            this.viewer.setView(this.secondPasse);
            for (TemplateLine line : this.collector) {
                this.template.addLine(line);
            }
            for (TemplateLine line : this.template.getLines()) {
                this.lines.put(line.getLineName(), line);
            }
        }
    }

    private XmlDocket getDocket() {
        XmlDocket docket;
        GroovyDocket.clearGroovyDockets();
        DocketTemplate.DocketType type = this.template.getType();
        if (type.equals((Object)DocketTemplate.DocketType.PREP_DOCKET)) {
            this.retrieveParamsForPrepDocket();
            docket = GroovyDocket.getPrepDocket((String)this.prepXMLFile);
        } else if (type.equals((Object)DocketTemplate.DocketType.TAKINGS_DOCKET)) {
            this.retrieveParamsForTakingsDocket();
            docket = GroovyDocket.getTakingsDocket();
        } else if (type.equals((Object)DocketTemplate.DocketType.RECEIPT)) {
            this.retrieveParamsForReceipt();
            docket = GroovyDocket.getReceiptDocket((String)this.receiptXMLFile);
        } else if (type.equals((Object)DocketTemplate.DocketType.DRIVER_SUMMARY)) {
            this.retrieveParamsForDriverSummary();
            docket = GroovyDocket.getDriverSummary();
        } else if (type.equals((Object)DocketTemplate.DocketType.TAKINGS_ALL_CASHDRAWER_DOCKET)) {
            this.retrieveParamsForTakingsDocket();
            docket = GroovyDocket.getTakingsAllCashdrawersDocket();
        } else if (type.equals((Object)DocketTemplate.DocketType.KTS_REPORT_DOCKET)) {
            this.retrieveParamsForKTSSummary();
            docket = GroovyDocket.getKtsReportDocket();
        } else if (type.equals((Object)DocketTemplate.DocketType.LABOUR_REPORT_DOCKET)) {
            this.retrieveParamsForWMSummary();
            docket = GroovyDocket.getLabourReportDocket();
        } else if (type.equals((Object)DocketTemplate.DocketType.ACCOUNT_SALES_REPORT_DOCKET)) {
            this.retrieveParamsForWMSummary();
            docket = GroovyDocket.getAccountSalesReportDocket();
        } else if (type.equals((Object)DocketTemplate.DocketType.COURSE_DOCKET)) {
            this.retrieveParamsForCourseDocket();
            docket = GroovyDocket.getCourseDocket();
        } else if (type.equals((Object)DocketTemplate.DocketType.STOCK_REQ_TEMPLATE)) {
            this.retrieveParamsForStockReqDocket();
            docket = GroovyDocket.getStockRequisitionDocket();
        } else if (type.equals((Object)DocketTemplate.DocketType.VOUCHER_DOCKET)) {
            this.retrieveParamsForVoucher();
            docket = GroovyDocket.getVoucherDocket();
        } else if (type.equals((Object)DocketTemplate.DocketType.COUPON_DOCKET)) {
            this.retrieveParamsForCoupon();
            docket = GroovyDocket.getCouponDocket();
        } else {
            throw new IllegalStateException("Unknown docket type : " + this.template.getType());
        }
        docket.setParams(this.params != null ? Arrays.asList(this.params) : null);
        docket.setTemplate(this.template);
        docket.setCollector(this.collector);
        return docket;
    }

    private void adjustSize() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension(500, screenSize.height - 150));
    }

    private void getModelAccount() {
        this.account = null;
        this.lastAccounts = null;
        ObjectQuery accountsSQL = Query.select(Account.class).equals(Account.Properties.ACCOUNT_TYPE, (Object)this.viewer.getSelectedAccountType()).orderByDesc(Account.Properties.ID).limit(100);
        this.lastAccounts = PersistenceManager.getObjectList(Account.class, (String)accountsSQL.toString(), (Object[])new Object[0]);
        if (this.lastAccounts.size() > 0) {
            this.accountIndex = 0;
            this.account = (Account)this.lastAccounts.get(this.accountIndex);
        }
        if (this.params != null) {
            this.params[0] = this.account;
        }
    }

    private void retrieveParamsForReceipt() {
        this.params = new Object[4];
        this.params[0] = this.account;
        this.params[1] = new Integer(1);
        this.params[2] = GuiApp.getAppComplex().getApplicationSecurity().getUser();
        this.params[3] = this.viewer.getSelectedPrinter();
    }

    private void retrieveParamsForPrepDocket() {
        this.params = new Object[8];
        this.params[0] = this.account;
        this.params[1] = Boolean.TRUE;
        this.params[2] = this.viewer.getSelectedPrinter();
        this.params[3] = this.viewer.getSelectedTerminal();
        this.params[4] = GuiApp.getAppComplex().getApplicationSecurity().getUser();
        this.params[5] = this.transfer ? this.account : null;
        this.params[6] = new Integer(999);
        this.params[7] = Boolean.TRUE;
    }

    private void retrieveParamsForStockReqDocket() {
        this.params = new Object[2];
        List results = StockRequisitionOrderQueries.getAllRequisitions();
        if (results != null && !results.isEmpty()) {
            StockRequisitionOrder order = (StockRequisitionOrder)results.get(0);
            this.params[0] = order;
            this.params[1] = order.getRequisitions();
        }
    }

    private void retrieveParamsForTakingsDocket() {
        RestaurantTakingsSummary summary = RestaurantTakingsSummary.getSummary((Shift)Shift.getLastShiftClosedOnOrBefore((Date)new Date()));
        summary.getCalculateTask().run();
        Terminal terminal = this.viewer.getSelectedTerminal();
        ArrayList<CashDrawerTakingsSummary> cashdrawerSummaries = new ArrayList<CashDrawerTakingsSummary>();
        if (terminal != null) {
            List cashdrawers = terminal.getAvailableLogicallyConnectedCashDrawers();
            for (CashDrawer cashdrawer : cashdrawers) {
                CashDrawerTakingsSummary cashdrawerSummary = CashDrawerTakingsSummary.getSummary((CashDrawer)cashdrawer, (Shift)terminal.getShift());
                cashdrawerSummaries.add(cashdrawerSummary);
            }
        }
        this.params = new Object[3];
        this.params[0] = summary;
        this.params[1] = cashdrawerSummaries;
        this.params[2] = terminal;
    }

    private void retrieveParamsForWMSummary() {
        RestaurantTakingsSummary summary = RestaurantTakingsSummary.getSummary((Shift)Shift.getLastShiftClosedOnOrBefore((Date)new Date()));
        summary.getCalculateTask().run();
        Terminal terminal = this.viewer.getSelectedTerminal();
        this.params = new Object[2];
        this.params[0] = summary;
        this.params[1] = terminal;
    }

    private void retrieveParamsForKTSSummary() {
        Shift shift = this.viewer.getSelectedTerminal().getShift();
        KTSDocketDataSummary summary = (KTSDocketDataSummary)PersistenceManager.getObject(KTSDocketDataSummary.class, (String)KTSDocketDataSummary.getSummaryQuery((Date)shift.getTradingDay().getOpenDateTime(), (Date)shift.getTradingDay().getCloseDateTime(), null).toString(), null);
        this.params = new Object[2];
        this.params[0] = summary;
        this.params[1] = shift;
    }

    private void retrieveParamsForVoucher() {
        this.params = new Object[2];
        List voucherTxns = this.account.getVoucherTxns();
        if (voucherTxns != null && !voucherTxns.isEmpty()) {
            GiftVoucherTransaction voucherTxn = (GiftVoucherTransaction)voucherTxns.get(0);
            this.params[0] = voucherTxn.getGiftVoucher();
        }
        this.params[1] = this.viewer.getSelectedPrinter();
    }

    private void retrieveParamsForCoupon() {
        this.params = new Object[2];
        this.params[0] = PersistenceManager.getObject(SalesCoupon.class, (String)Query.select(SalesCoupon.class).limit(1).toString());
        if (null == this.params[0]) {
            this.params[0] = new SalesCoupon((InventoryCoupon)new PriceAdjustmentCoupon(), "0");
        }
        this.params[1] = this.viewer.getSelectedPrinter();
    }

    private void retrieveParamsForCourseDocket() {
        this.params = new Object[8];
        this.params[0] = this.account;
        this.params[1] = Course.getCourses().get(0);
        this.params[2] = this.viewer.getSelectedTerminal().getSeatNums() && this.account.usesSeatNums();
        this.params[3] = this.viewer.getSelectedPrinter();
        this.params[4] = this.viewer.getSelectedTerminal();
        this.params[5] = GuiApp.getAppComplex().getApplicationSecurity().getUser();
    }

    private void setViewAttributeAlign(String align) {
        if (align != null && align.equals("center")) {
            this.viewer.setViewAlignCenter(true);
            this.viewer.setViewAlignRight(false);
            this.viewer.setViewAlignLeft(false);
        } else if (align != null && align.equals("right")) {
            this.viewer.setViewAlignCenter(false);
            this.viewer.setViewAlignRight(true);
            this.viewer.setViewAlignLeft(false);
        } else {
            this.viewer.setViewAlignCenter(false);
            this.viewer.setViewAlignRight(false);
            this.viewer.setViewAlignLeft(true);
        }
    }

    private void setViewAttributeColor(String color) {
        if (color != null && color.equals("red")) {
            this.viewer.setViewColorRed(true);
        } else {
            this.viewer.setViewColorRed(false);
        }
    }

    private void setViewAttributeVisible(String visible) {
        if (visible != null && visible.equals("false")) {
            this.viewer.setViewVisible(false);
        } else {
            this.viewer.setViewVisible(true);
        }
    }

    private void setViewAttributeWeight(String weight) {
        if (weight != null && weight.equals("tall")) {
            this.viewer.setViewWeightTall(true);
            this.viewer.setViewWeightWide(false);
        } else if (weight != null && weight.equals("wide")) {
            this.viewer.setViewWeightTall(false);
            this.viewer.setViewWeightWide(true);
        } else if (weight != null && weight.equals("big")) {
            this.viewer.setViewWeightTall(true);
            this.viewer.setViewWeightWide(true);
        } else {
            this.viewer.setViewWeightTall(false);
            this.viewer.setViewWeightWide(false);
        }
    }

    private void setViewAttributeUnderline(String underline) {
        this.viewer.setViewUnderline(underline);
    }

    private void setViewAttributeInverted(String inverted) {
        this.viewer.setViewInverted(Boolean.TRUE.toString().equals(inverted));
    }

    private void setViewAttributeReplace(String replace) {
        this.viewer.setViewReplace(replace);
    }

    @Override
    public void saveObject() {
        this.template.setLines(new ArrayList<TemplateLine>(this.lines.values()));
        super.saveObject();
        BusinessInfo.getInstance().save();
    }

    @Override
    public void revertObject() {
        if (this.template != null && this.template.isPersistent()) {
            this.template.setLines(((DocketTemplate)PersistenceManager.reacquire((PersistentObjectI)this.template)).getLines());
        }
    }
}

