/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.report.config.schedule.wizard;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.wizard.AbstractWizardState;
import officemate.adminkit.wizard.GenericWizard;
import officemate.components.table.PersistentObjectTable;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.setup.configuration.report.config.schedule.wizard.ReportConfigScheduleCronSetWizardState;
import officemate.screens.setup.configuration.report.config.wizard.ReportConfigWizardState;
import ordermate.database.config.report.ReportConfig;
import ordermate.database.config.report.ReportConfigSchedule;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class ReportConfigScheduleSelectionWizardState
extends AbstractWizardState
implements ActionListener {
    private PersistentObjectTable<ReportConfig> table;
    private JButton newConfig;

    public ReportConfigScheduleSelectionWizardState() {
        super(new ReportConfigScheduleCronSetWizardState());
    }

    @Override
    public JPanel initCentralContent() {
        JPanel toReturn = new JPanel(new BorderLayout());
        ColumnTableFormat format = new ColumnTableFormat();
        format.addColumn((ColumnFormat)new PropertyColumnFormat(ReportConfig.Properties.LABEL));
        format.addColumn((ColumnFormat)new PropertyColumnFormat(ReportConfig.Properties.TYPE));
        this.table = new PersistentObjectTable<ReportConfig>(this.getTableContents(), format);
        this.newConfig = new JButton("Create New Report Configuration");
        this.newConfig.addActionListener(this);
        JPanel buttonWrapper = new JPanel();
        buttonWrapper.add(this.newConfig);
        toReturn.add(this.table, "Center");
        toReturn.add((Component)buttonWrapper, "South");
        return toReturn;
    }

    @Override
    public String getInstructionText() {
        return "Which report configuration would you like to schedule?";
    }

    @Override
    public String getTitleBarText() {
        return "Select a report";
    }

    public boolean prepareForStateChange(PersistentObject object) {
        ReportConfig config = null;
        if (object != null) {
            config = ((ReportConfigSchedule)object).getReportConfig();
        }
        if (config == null) {
            config = this.table.getSelectedObject();
            this.newObjectReceived.emit((Object)new ReportConfigSchedule(config));
        }
        if (config == null) {
            Dialogs.showInfoDialog("Oops!", "A report configuration must be selected before you can continue.");
            return false;
        }
        return config.isPersistent();
    }

    public void prepareForReturn(PersistentObject object) {
        this.killObject.emit();
    }

    private EventList<ReportConfig> getTableContents() {
        List configs = PersistenceManager.getObjectList(ReportConfig.class, (String)Query.select(ReportConfig.class).active(ReportConfig.class).toString());
        return GlazedLists.eventList((Collection)configs);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        GenericWizard wizard;
        Object source = e.getSource();
        if (source == this.newConfig && (wizard = new GenericWizard(new ReportConfigWizardState(), new Dimension(450, 400))).getObject() != null && ((ReportConfig)wizard.getObject()).isPersistent()) {
            this.newObjectReceived.emit((Object)new ReportConfigSchedule((ReportConfig)wizard.getObject()));
            this.changeState.emit();
        }
    }
}

