/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.report.custom;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.AddRemovePanel;
import ordermate.database.reports.config.custom.CustomReport;
import ordermate.database.reports.config.custom.column.CustomColumnFactory;
import ordermate.database.reports.config.custom.column.CustomReportColumn;
import ordermate.database.reports.config.custom.column.CustomReportColumnType;
import ordermate.database.reports.config.custom.column.direct.BaseReport;
import ordermate.database.reports.config.custom.column.direct.DirectReportColumn;
import ordermate.database.reports.config.custom.compiler.DefaultBaseReportCompilerFactory;

class ColumnMultiAdd
implements ActionListener {
    private AddRemovePanel<ColumnDesc> addRemove;
    private JComboBox baseReports;

    public void doMultiAdd(CustomReport report) {
        JPanel holder = new JPanel();
        holder.setLayout(new BoxLayout(holder, 1));
        this.baseReports = new JComboBox<BaseReport>(BaseReport.values());
        holder.add(this.baseReports);
        this.baseReports.addActionListener(this);
        this.addRemove = new AddRemovePanel();
        this.addRemove.setDuplicatePolicy(AddRemovePanel.DuplicatePolicy.Deny);
        holder.add(this.addRemove);
        if (Dialogs.showOkCustomDialog("Add Columns", "Please select your columns to add.", holder)) {
            int seq = 0;
            for (CustomReportColumn col : report.getColumns()) {
                if (seq >= col.getSequence()) continue;
                seq = col.getSequence();
            }
            CustomColumnFactory factory = new CustomColumnFactory();
            for (ColumnDesc desc : this.addRemove.getAddedList()) {
                DirectReportColumn col = (DirectReportColumn)factory.makeColumn(CustomReportColumnType.Direct, report);
                col.setSequence(++seq);
                col.setBaseReport(desc.report);
                col.setBaseReportProperty(desc.prop);
                col.setLabel(desc.prop);
                report.addColumn((CustomReportColumn)col);
            }
        }
    }

    private void populatePool() {
        BaseReport report = (BaseReport)this.baseReports.getSelectedItem();
        if (report != null) {
            ArrayList<ColumnDesc> pool = new ArrayList<ColumnDesc>();
            for (String nextCol : new DefaultBaseReportCompilerFactory().createCompiler(report, null).getDirectColumns()) {
                ColumnDesc desc = new ColumnDesc();
                desc.prop = nextCol;
                desc.report = report;
                pool.add(desc);
            }
            this.addRemove.setPoolList(pool);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.populatePool();
    }

    private class ColumnDesc
    implements Comparable {
        BaseReport report;
        String prop;

        private ColumnDesc() {
        }

        public String toString() {
            return this.report + "." + this.prop;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof ColumnDesc) {
                return ((ColumnDesc)other).report.equals((Object)this.report) && ((ColumnDesc)other).prop.equals(this.prop);
            }
            return false;
        }

        public int compareTo(Object o) {
            return this.prop.compareTo(((ColumnDesc)o).prop);
        }
    }
}

