/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.report.custom;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import officemate.components.AbstractObjectEditor;
import ordermate.database.reports.config.custom.column.CustomReportColumn;
import ordermate.gui.FieldPanelBuilder;
import ordermate.internationalization.Internationalization;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Validator;

abstract class CustomReportColumnEditor
extends AbstractObjectEditor<CustomReportColumn> {
    private JTextField keyField;

    CustomReportColumnEditor() {
    }

    @Override
    protected void init() {
        super.init();
        this.getBindings().setStrategy(AutoBinding.UpdateStrategy.READ_WRITE);
        FieldPanelBuilder builder = new FieldPanelBuilder();
        builder.addRow("Title", (Component)this.setupTextField(CustomReportColumn.Properties.LABEL, 20, new BadJasperNameValidator()));
        this.keyField = new JTextField(20);
        builder.addRow("Unique Key", (Component)this.keyField);
        builder.addRow("Sequence", (Component)this.setupIntSpinner(CustomReportColumn.Properties.SEQUENCE, 1, 0, Integer.MAX_VALUE, 1, 10));
        builder.addRow("Visible", (Component)this.setupCheckBox(CustomReportColumn.Properties.VISIBLE));
        EventList formats = GlazedLists.eventListOf((Object[])new String[]{"", "#,##0", Internationalization.getLiteralFor((String)"DOLLAR_SIGN") + "#,##0.00", "0.00%", "0.#%"});
        JComboBox formatBox = this.setupComboBox(CustomReportColumn.Properties.FORMAT, formats);
        formatBox.setEditable(true);
        builder.addRow("Format", (Component)formatBox);
        builder.addRow("Default Value", (Component)this.setupTextField(CustomReportColumn.Properties.DEFAULT_VALUE, 20, null));
        builder.addRow("In Total", (Component)this.setupCheckBox(CustomReportColumn.Properties.IN_TOTAL));
        builder.addRow("In Average", (Component)this.setupCheckBox(CustomReportColumn.Properties.IN_AVERAGE));
        builder.addRow("Ignore Zeros In Average", (Component)this.setupCheckBox(CustomReportColumn.Properties.IGNORE_ZEROS_IN_AVERAGE));
        builder.addRow("Width", (Component)this.setupIntegerField(CustomReportColumn.Properties.WIDTH, 10, null));
        builder.addRow("Background", (Component)this.setupColorSelection(CustomReportColumn.Properties.BACKGROUND));
        builder.addRow("Header Background", (Component)this.setupColorSelection(CustomReportColumn.Properties.HEADER_BACKGROUND));
        builder.addSeparator("");
        this.addChildComponents(builder);
        this.add((Component)builder.getPanel(), "Center");
    }

    @Override
    public void saveObject() {
        super.saveObject();
        ((CustomReportColumn)this.getObject()).getReport().setKey(this.keyField.getText(), (CustomReportColumn)this.getObject());
        ((CustomReportColumn)this.getObject()).getReport().columnsUpdated();
    }

    @Override
    public void setObject(CustomReportColumn value) {
        super.setObject(value);
        this.keyField.setText(value.getUniqueKey());
    }

    protected abstract void addChildComponents(FieldPanelBuilder var1);

    class BadJasperNameValidator
    extends Validator {
        BadJasperNameValidator() {
        }

        public Validator.Result validate(Object arg0) {
            if (arg0 == null) {
                return new Validator.Result((Validator)this, arg0, "Cannot have an empty label");
            }
            String value = String.valueOf(arg0).trim();
            if (value.isEmpty()) {
                return new Validator.Result((Validator)this, (Object)value, "Cannot have an empty label");
            }
            if (value.startsWith(Internationalization.getLiteralFor((String)"DOLLAR_SIGN")) || value.startsWith("%")) {
                return new Validator.Result((Validator)this, (Object)value, "Cannot start with % or " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
            }
            return null;
        }
    }
}

