/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.report.custom;

import au.com.ordermate.persistence.PropertiedObject;
import ca.odell.glazedlists.BasicEventList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JButton;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.EditorDialog;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableListObjectEditor;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.setup.configuration.report.custom.ColumnMultiAdd;
import officemate.screens.setup.configuration.report.custom.CustomReportColumnEditor;
import officemate.screens.setup.configuration.report.custom.DerivedColumnEditor;
import officemate.screens.setup.configuration.report.custom.DirectColumnEditor;
import ordermate.database.reports.config.custom.CustomReport;
import ordermate.database.reports.config.custom.column.CustomColumnFactory;
import ordermate.database.reports.config.custom.column.CustomReportColumn;
import ordermate.database.reports.config.custom.column.CustomReportColumnType;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class CustomReportColumnTable
extends TableListObjectEditor<CustomReport, CustomReportColumn>
implements ActionListener {
    private JButton multiAddButton;

    public CustomReportColumnTable() {
        super(new PersistentObjectTable(new BasicEventList(), new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(CustomReportColumn.Properties.LABEL), new PropertyColumnFormat((PropertiedObject.Property)CustomReportColumn.Properties.DATA_STRING), new PropertyColumnFormat(CustomReportColumn.Properties.UNIQUE_KEY), new PropertyColumnFormat(CustomReportColumn.Properties.WIDTH), new PropertyColumnFormat(CustomReportColumn.Properties.IN_AVERAGE), new PropertyColumnFormat(CustomReportColumn.Properties.IN_TOTAL), new PropertyColumnFormat(CustomReportColumn.Properties.SEQUENCE), new PropertyColumnFormat(CustomReportColumn.Properties.VISIBLE)})));
        this.getObjectTable().objectDoubleClicked().connect((Object)this, "gotDoubleClick");
        this.multiAddButton = new JButton("Multi Add");
        this.multiAddButton.addActionListener(this);
        this.getToolBar().add(this.multiAddButton);
    }

    @Override
    public CustomReportColumn createNewObject() {
        CustomColumnFactory factory = new CustomColumnFactory();
        CustomReportColumnType type = (CustomReportColumnType)Dialogs.showOptionDialog("Column Type", "Please choose the type of column you would like to create.", Arrays.asList(CustomReportColumnType.values()));
        return type == null ? null : factory.makeColumn(type, (CustomReport)this.getObject());
    }

    public void gotDoubleClick(Object value) {
        CustomReportColumnType type = ((CustomReportColumn)value).getColumnType();
        CustomReportColumnEditor editor = null;
        switch (type) {
            case Direct: {
                editor = new DirectColumnEditor();
                break;
            }
            case Derived: {
                editor = new DerivedColumnEditor();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown column type " + type);
            }
        }
        if (editor != null) {
            editor.setObject((CustomReportColumn)value);
            EditorDialog dialog = new EditorDialog(editor);
            if (dialog.doModal()) {
                editor.saveObject();
            }
        }
    }

    @Override
    public void addObjectToParent(CustomReportColumn toAdd) {
        ((CustomReport)this.getObject()).addColumn(toAdd);
    }

    @Override
    public void removeObjectFromParent(CustomReportColumn toRemove) {
        ((CustomReport)this.getObject()).removeColumn(toRemove);
    }

    @Override
    public Collection<CustomReportColumn> getParentList() {
        return ((CustomReport)this.getObject()).getSequencedColumns();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.multiAddButton) {
            new ColumnMultiAdd().doMultiAdd((CustomReport)this.getObject());
            this.setObject(this.getObject());
        }
    }
}

