/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.report.custom;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import officemate.components.AbstractObjectEditor;
import officemate.screens.reports.custom.CustomReportStateHelper;
import officemate.screens.setup.configuration.report.custom.CustomReportColumnTable;
import officemate.screens.setup.configuration.report.custom.CustomReportQueryPartTable;
import officemate.screens.setup.configuration.report.custom.CustomReportSeriesEditor;
import officemate.screens.setup.configuration.report.custom.CustomReportSubReportEditor;
import ordermate.database.reports.config.BaseReportGrouping;
import ordermate.database.reports.config.custom.CustomReport;
import ordermate.database.reports.config.custom.JasperBorder;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.FontAttributesEditor;

public class CustomReportEditor
extends AbstractObjectEditor<CustomReport> {
    private CustomReportSeriesEditor series;
    private CustomReportColumnTable columns;
    private CustomReportSubReportEditor subReports;
    private CustomReportQueryPartTable queryPartEditor;
    FontAttributesEditor columnFontEditor;
    FontAttributesEditor columnHeaderFontEditor;
    FontAttributesEditor titleFontEditor;
    FontAttributesEditor subtitleFontEditor;

    @Override
    protected void init() {
        super.init();
        FieldPanelBuilder builder = new FieldPanelBuilder();
        builder.addRow("Title", (Component)this.setupTextField(CustomReport.Properties.TITLE, 20));
        builder.addRow("SubTitle", (Component)this.setupTextField(CustomReport.Properties.SUB_TITLE, 20));
        builder.addRow("Show Title", (Component)this.setupCheckBox(CustomReport.Properties.SHOW_TITLE));
        builder.addRow("Show Banner", (Component)this.setupCheckBox(CustomReport.Properties.SHOW_BANNER));
        BasicEventList borderValues = new BasicEventList();
        for (JasperBorder border : JasperBorder.values()) {
            borderValues.add((Object)border.name());
        }
        builder.addRow("Column Border", (Component)this.setupComboBox(CustomReport.Properties.COLUMN_BORDER, borderValues));
        builder.addRow("Default Period", (Component)this.setupTextField(CustomReport.Properties.DEFAULT_PERIOD, 20));
        builder.addRow("Sequence", (Component)this.setupIntSpinner(CustomReport.Properties.SEQUENCE, 1, -100, 100, 1, 5));
        builder.addRow("Landscape?", (Component)this.setupCheckBox(CustomReport.Properties.LANDSCAPE));
        builder.addRow("Page Break?", (Component)this.setupCheckBox(CustomReport.Properties.PAGE_BREAK));
        builder.addRow("Title Height", (Component)this.setupIntSpinner(CustomReport.Properties.TITLE_HEIGHT, 5, 1, 1000, 50, 5));
        builder.addRow("Header Height", (Component)this.setupIntSpinner(CustomReport.Properties.HEADER_HEIGHT, 5, 1, 1000, 50, 5));
        builder.addRow("Header Rotation", (Component)this.setupComboBox(CustomReport.Properties.HEADER_ROTATION, GlazedLists.eventListOf((Object[])new String[]{"Left", "Right", "None"})));
        builder.addRow("Grouping", (Component)this.setupComboBox(CustomReport.Properties.GROUPING, GlazedLists.eventListOf((Object[])BaseReportGrouping.values())));
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab("General", builder.getPanel());
        tabs.addTab("Fonts", this.makeFontsPanel());
        this.series = new CustomReportSeriesEditor();
        tabs.addTab("Series", this.series);
        this.columns = new CustomReportColumnTable();
        tabs.addTab("Columns", this.columns);
        this.subReports = new CustomReportSubReportEditor();
        tabs.addTab("Sub Reports", this.subReports);
        this.queryPartEditor = new CustomReportQueryPartTable();
        tabs.addTab("Advanced", this.queryPartEditor);
        this.add((Component)tabs, "Center");
    }

    private JPanel makeFontsPanel() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.columnFontEditor = new FontAttributesEditor();
        builder.addRow("Column", (Component)this.columnFontEditor);
        this.columnHeaderFontEditor = new FontAttributesEditor();
        builder.addRow("Column Header", (Component)this.columnHeaderFontEditor);
        this.titleFontEditor = new FontAttributesEditor();
        builder.addRow("Title", (Component)this.titleFontEditor);
        this.subtitleFontEditor = new FontAttributesEditor();
        builder.addRow("Subtitle", (Component)this.subtitleFontEditor);
        return builder.getPanel();
    }

    @Override
    public void setObject(CustomReport report) {
        super.setObject(report);
        this.series.setObject(report);
        this.columns.setObject(report);
        this.queryPartEditor.setObject(report);
        this.subReports.setObject(report);
        this.columnFontEditor.setAttributes(report.getColumnFont());
        this.columnHeaderFontEditor.setAttributes(report.getColumnHeaderFont());
        this.titleFontEditor.setAttributes(report.getTitleFont());
        this.subtitleFontEditor.setAttributes(report.getSubtitleFont());
    }

    @Override
    public void saveObject() {
        super.saveObject();
        this.series.saveObject();
        this.columns.saveObject();
        this.queryPartEditor.saveObject();
        this.subReports.saveObject();
        CustomReportStateHelper.updateAffectedCustomPermissions((CustomReport)this.getObject());
    }
}

