/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.report.custom;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.view.JasperViewer;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.reports.custom.CustomReportStateHelper;
import officemate.screens.setup.configuration.report.custom.CustomReportEditor;
import ordermate.OrderMate;
import ordermate.database.io.PersistentObjectIO;
import ordermate.database.reports.config.custom.CustomReport;
import ordermate.database.reports.config.custom.CustomReportIO;
import ordermate.database.reports.config.custom.CustomReportProvider;
import ordermate.database.reports.config.custom.compiler.CustomReportCompiler;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class CustomReportSetupState
extends AbstractEditableTableState<CustomReport> {
    private final CustomReportIO io = new CustomReportIO();
    private final PersistentObjectIO<CustomReport> newIO = new PersistentObjectIO();

    public CustomReportSetupState() {
        this.addSelectionDependentAction(new PreviewAction());
        this.addSelectionDependentAction(new ExportAction());
        this.addAction((Action)((Object)new ImportAction()));
        this.addAction((Action)((Object)new RefreshTransientReportsAction()));
    }

    @Override
    protected ObjectEditor<CustomReport> createObjectEditor() {
        return new CustomReportEditor();
    }

    @Override
    public String getTypeName() {
        return "Custom Report";
    }

    @Override
    protected TableStateCentralArea<CustomReport> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(CustomReport.Properties.TITLE), new PropertyColumnFormat(CustomReport.Properties.SUB_TITLE), new PropertyColumnFormat(CustomReport.Properties.LANDSCAPE), new PropertyColumnFormat(CustomReport.Properties.DEFAULT_PERIOD), new PropertyColumnFormat(CustomReport.Properties.PARENT)});
        PersistentObjectTable<CustomReport> table = new PersistentObjectTable<CustomReport>(this.getObjectList(), format);
        table.getTable().setName("CustomReportsTable");
        return table;
    }

    @Override
    protected Class<CustomReport> getDisplayingType() {
        return CustomReport.class;
    }

    @Override
    protected CustomReport createNewObject() {
        CustomReport report = new CustomReport("New Custom Report", null);
        return report;
    }

    protected CustomReportCompiler createCompiler(CustomReport report) {
        return new CustomReportCompiler(report);
    }

    private CustomReport getSelectedReport(String action) {
        CustomReport selectedReport = (CustomReport)this.getCentralArea().getSelectedObject();
        if (selectedReport == null) {
            Dialogs.showInfoDialog("No Report", "Please select a report before pressing " + action);
        }
        return selectedReport;
    }

    private class RefreshTransientReportsAction
    extends BasicAction {
        public RefreshTransientReportsAction() {
            super("Reload from Disk", (Icon)IconLoader.get((String)"/officemate/images/refresh_new.png"), "Reloads the custom report cache for any reports stored in files on ServerMate rather than in the database.");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                CustomReportStateHelper.getCustomReportManager().refreshAvailableReports();
                Dialogs.showInfoDialog("Success!", "Success! Please restart OfficeMate in order for new custom reports to appear in the navigation tree.");
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Failed to refresh available custom reports over RMI!", (Throwable)ex);
            }
        }
    }

    private final class ImportAction
    extends BasicAction {
        final JFileChooser chooser;

        public ImportAction() {
            super("Import", (Icon)IconLoader.get((String)"/ordermate/images/button_import.png"), "Import existing report.");
            this.chooser = new JFileChooser();
        }

        public void actionPerformed(ActionEvent e) {
            int responseVal = this.chooser.showOpenDialog(CustomReportSetupState.this.getScreenPanel());
            if (responseVal == 0) {
                CustomReport report = null;
                FileInputStream bin = null;
                try {
                    bin = new FileInputStream(this.chooser.getSelectedFile());
                    report = (CustomReport)CustomReportSetupState.this.newIO.readIn((InputStream)bin);
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("Cannot read in custom report with XML Scanner. Trying old skool", (Throwable)ex);
                    try {
                        if (bin != null) {
                            bin.close();
                            bin = null;
                        }
                        bin = new FileInputStream(this.chooser.getSelectedFile());
                        report = CustomReportSetupState.this.io.readIn((InputStream)bin);
                    }
                    catch (Exception exc) {
                        OrderMate.LOG.error("Cannot import report ", (Throwable)exc);
                        if (bin != null) {
                            try {
                                bin.close();
                                bin = null;
                            }
                            catch (Exception exception) {
                                OrderMate.LOG.error("Cannot close FileInputStream ", (Throwable)exception);
                            }
                        }
                        Dialogs.showWarningDialog("Cannot import report", "There was an error importing the report, please see the logs.");
                    }
                }
                if (report != null) {
                    report.save();
                    try {
                        if (bin != null) {
                            bin.close();
                            bin = null;
                        }
                    }
                    catch (Exception exception) {
                        OrderMate.LOG.error("Cannot close FileInputStream ", (Throwable)exception);
                    }
                    Dialogs.showMessageDialog("Successfully Imported", "Report imported successfully.");
                    CustomReportSetupState.this.refresh();
                }
            }
        }
    }

    private final class ExportAction
    extends AbstractAction {
        final JFileChooser chooser;

        ExportAction() {
            super("Export", IconLoader.get((String)"/ordermate/images/rightarrow.png"));
            this.chooser = new JFileChooser();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomReport selectedReport = CustomReportSetupState.this.getSelectedReport("export");
            if (selectedReport != null) {
                String option = (String)Dialogs.showOptionDialog("XML or Fixed?", "Do you wish to export using the new XML form (recommended) or the old fixed (for legacy only)?", Arrays.asList("XML", "Legacy"));
                try {
                    int responseVal = this.chooser.showSaveDialog(CustomReportSetupState.this.getScreenPanel());
                    if (responseVal == 0) {
                        String file = this.chooser.getSelectedFile().getAbsolutePath();
                        if (!file.contains(".")) {
                            file = file + ".rep";
                        }
                        FileOutputStream output = new FileOutputStream(file);
                        if ("Legacy".equals(option)) {
                            CustomReportSetupState.this.io.writeCustomReport(selectedReport, (OutputStream)output);
                        } else {
                            CustomReportSetupState.this.newIO.writeOut((Object)selectedReport, (OutputStream)output);
                        }
                        output.flush();
                        output.close();
                        Dialogs.showMessageDialog("Successfully Exported", "Report exported successfully.");
                    }
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("Cannot export report " + selectedReport.getTitle(), (Throwable)ex);
                    Dialogs.showWarningDialog("Cannot export report", "There was an error exporting the report, please see the logs.");
                }
            }
        }
    }

    class PreviewAction
    extends AbstractAction {
        private Date lastPreview;

        PreviewAction() {
            super("Preview", IconLoader.get((String)"/ordermate/images/view_report.png"));
            this.lastPreview = new Date();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomReport selectedReport = CustomReportSetupState.this.getSelectedReport("preview");
            if (selectedReport != null) {
                SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
                String output = format.format(this.lastPreview);
                String input = JOptionPane.showInputDialog(CustomReportSetupState.this.getCentralArea().getComponent(), "Please select a date to preview", output);
                if (input != null) {
                    try {
                        Date newDate;
                        this.lastPreview = newDate = format.parse(input);
                    }
                    catch (Exception ex) {
                        OrderMate.LOG.error("Using default since I cannot parse " + input);
                    }
                    CustomReportCompiler compiler = CustomReportSetupState.this.createCompiler(selectedReport);
                    compiler.setPeriodReportAdapter(PeriodReportAdapter.DAILY);
                    compiler.setReportDate(this.lastPreview);
                    CustomReportProvider provider = new CustomReportProvider(compiler);
                    try {
                        compiler.compileReport();
                        JasperViewer viewer = new JasperViewer(provider.getReportPrint(), false);
                        viewer.setVisible(true);
                    }
                    catch (JRException ex) {
                        OrderMate.LOG.error("Cannot preview report", (Throwable)ex);
                        Dialogs.showWarningDialog("Cannot show report", "There was an error showing the report, please see the logs.");
                    }
                }
            }
        }
    }
}

