/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.systemproperty;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import officemate.components.AbstractObjectEditor;
import officemate.components.BindingGuiSupportPanel;
import officemate.screens.setup.configuration.systemproperty.twitter.TwitterCredentialsEditor;
import ordermate.OrderMate;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.ItemBarcodeType;
import ordermate.database.misc.enums.MessageServerType;
import ordermate.database.misc.enums.OnlineIntegrationIDStrategy;
import ordermate.database.misc.enums.PropertyIntegrationType;
import ordermate.database.misc.enums.ReservationIntegrationType;
import ordermate.database.misc.enums.ReservationWarnType;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.BindingHelper;
import ordermate.integration.cloudback.nudge.NudgeHelper;

public class IntegrationSystemPropertyEditor
extends AbstractObjectEditor<SystemProperty>
implements ActionListener,
ItemListener {
    private JComboBox<MessageServerType> messageServerTypeJComboBox;

    public IntegrationSystemPropertyEditor(BindingHelper<SystemProperty> parentBinding, BindingGuiSupportPanel.ObjectEditedListener parentListener) {
        super(parentBinding, parentListener);
    }

    @Override
    protected void init() {
        super.init();
        FieldPanelBuilder leftBuilder = new FieldPanelBuilder();
        JComponent toAdd = null;
        this.messageServerTypeJComboBox = this.setupComboBox(SystemProperty.Properties.MESSAGE_SERVER_TYPE, GlazedLists.eventListOf((Object[])MessageServerType.values()));
        leftBuilder.addRow("Message Server", this.messageServerTypeJComboBox, "Determine the Message Server Type");
        toAdd = this.setupCheckBox(SystemProperty.Properties.CCTV_ENABLED);
        leftBuilder.addRow("CCTV", (Component)toAdd, "Enable/Disable CCTV integration");
        toAdd = this.setupCheckBox(SystemProperty.Properties.BAR_STOCK_ENABLED);
        leftBuilder.addRow("Barstock", (Component)toAdd, "Enable/Disable Bar Stock integration");
        toAdd = this.setupCheckBox(SystemProperty.Properties.REPLICATION_ENABLED);
        leftBuilder.addRow("Replication", (Component)toAdd, "Enable/Disable Replication integration");
        String twitterConfigState = this.getTwitterConfigState();
        final JButton twitterButton = new JButton(twitterConfigState);
        twitterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TwitterCredentialsEditor twitterDialog = new TwitterCredentialsEditor();
                twitterDialog.setVisible(true);
                if (twitterDialog.isConfigured()) {
                    SystemProperty.getInstance().setTwitterUserName(twitterDialog.getUsername());
                    String[] token = twitterDialog.getAccessTokens();
                    SystemProperty.getInstance().setTwitterAccessToken(token[0]);
                    SystemProperty.getInstance().setTwitterAccessSecretToken(token[1]);
                    SystemProperty.getInstance().setTwitterActive(twitterDialog.isTwitterActive());
                    IntegrationSystemPropertyEditor.this.getListener().fireObjectEdited();
                }
                twitterButton.setText(IntegrationSystemPropertyEditor.this.getTwitterConfigState());
            }
        });
        leftBuilder.addRow("Twitter Support", (Component)twitterButton, "Configure the Twitter integration by entering the Twitter account/login details");
        toAdd = this.setupCheckBox(SystemProperty.Properties.ONLINE_INTEGRATION_PRINT_DOCKET_ONLY);
        leftBuilder.addRow("Online Integration Print Only", (Component)toAdd, "Enable/Disable online integration to be print only");
        toAdd = this.setupCheckBox(SystemProperty.Properties.ONLINE_INTEGRATION_FULL);
        leftBuilder.addRow("Online Integration Full", (Component)toAdd, "Enable/Disable full online integration mode");
        toAdd = this.setupCheckBox(SystemProperty.Properties.BLOCK_DUPLICATE_ONLINE_ORDERS);
        leftBuilder.addRow("Block Duplicate Online Orders", (Component)toAdd, "Enable/Disable duplicate online orders to be blocked");
        toAdd = this.setupTextField(SystemProperty.Properties.CAMERA_VIEW_IP, 20);
        leftBuilder.addRow("Camera Viewer IP", (Component)toAdd, "Configure the host IP address for CCTV integration");
        toAdd = this.setupTextField(SystemProperty.Properties.CAMERA_VIEW_PORT, 10);
        leftBuilder.addRow("Camera Viewer Port", (Component)toAdd, "Configure the host port for CCTV integration");
        toAdd = this.setupComboBox(SystemProperty.Properties.ITEM_BARCODE_TYPE, GlazedLists.eventListOf((Object[])ItemBarcodeType.values()));
        leftBuilder.addRow("Item Barcode Type", (Component)toAdd, "Determine the barcode type used for scales integration");
        toAdd = this.setupCheckBox(SystemProperty.Properties.ON_THREAD_INTEGRATION);
        leftBuilder.addRow("On-Thread Processing of Integration", (Component)toAdd, "Enable/Disable data sent in integrations to be loaded on a single thread");
        FieldPanelBuilder rightBuilder = new FieldPanelBuilder();
        EventList propIntList = GlazedLists.eventList(PropertyIntegrationType.register.values());
        toAdd = this.setupComboBox(SystemProperty.Properties.PROPERTY_INTEGRATION, propIntList);
        rightBuilder.addRow("Property Integration Type", (Component)toAdd, "Determine the property integration type to be used");
        toAdd = this.setupLongField(SystemProperty.Properties.RMS_CASH_ACCOUNT_ID, 20, null, null);
        toAdd.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (!Character.isDigit(c) && c != '\b') {
                    e.consume();
                }
            }
        });
        rightBuilder.addRow("RMS Cash Account Id", (Component)toAdd, "Configure the RMS cash account Id for the non-room sales and payments.");
        EventList resIntList = GlazedLists.eventListOf((Object[])ReservationIntegrationType.values());
        toAdd = this.setupComboBox(SystemProperty.Properties.RESERVATION_INTEGRATION, resIntList);
        rightBuilder.addRow("Reservation Integration Type", (Component)toAdd, "Determine the reservations integration type to be used");
        EventList resWarningList = GlazedLists.eventListOf((Object[])ReservationWarnType.values());
        toAdd = this.setupComboBox(SystemProperty.Properties.RESERVATION_WARN, resWarningList);
        rightBuilder.addRow("Reservation Warn Type", (Component)toAdd, "Determine the reservations warn type to be used");
        toAdd = this.setupTimeSpinner(SystemProperty.Properties.MESSAGE_SERVER_POLL_TIME);
        rightBuilder.addRow("Message Server Poll Time", (Component)toAdd, "Configure the time in seconds to receive the mail from the POP3 server");
        toAdd = this.setupTimeSpinner(SystemProperty.Properties.MESSAGE_UPDATER_POLL_TIME);
        rightBuilder.addRow("Message Updater Poll Time", (Component)toAdd, "Configure the time in seconds that the server will check for scheduled reports to be sent");
        toAdd = this.setupTextField(SystemProperty.Properties.REMOTE_MONITOR_URL, 20);
        rightBuilder.addRow("Remote Monitor URL", (Component)toAdd, "Configure the URL path for remote monitoring of the OrderMate system");
        if (PersistentLicenseManager.getInstance().getBoolean(LicenseType.LiquorfileIntegrationEnabled)) {
            toAdd = this.setupCheckBox(SystemProperty.Properties.LIQUORFILE_ENABLED);
            rightBuilder.addRow("Liquorfile Enabled", (Component)toAdd, "Enable/Disable the liquorfile pricebook integration");
        }
        toAdd = this.setupCheckBox(SystemProperty.Properties.ENFORCE_BIOMETRIC_CLOCKON);
        rightBuilder.addRow("Enforce Fingerprint Clock-On", (Component)toAdd, "Enable/Disable force users to clock on using a fingerprint scanner");
        toAdd = this.setupComboBox(SystemProperty.Properties.ONLINE_INTEGRATION_ID_STRATEGY, GlazedLists.eventList(Arrays.asList(OnlineIntegrationIDStrategy.values())));
        rightBuilder.addRow("Online Integration ID Strategy", (Component)toAdd, "Determine the strategy for using IDs in online ordering integration");
        toAdd = this.setupCheckBox(SystemProperty.Properties.SUGGESTED_ORDER_INC_PURCHASES);
        rightBuilder.addRow("Suggested Ordering inc Purchases", (Component)toAdd, "Enable/Disable include the values for existing purchase orders when generating a suggested order");
        toAdd = this.setupCheckBox(SystemProperty.Properties.REASSIGN_CUSTOMER_COMMENT);
        rightBuilder.addRow("Reassign Customer Comments to Account Comments", (Component)toAdd, "Enable/Disable online order customer comments to be added to the account comments");
        toAdd = this.setupNumberSpinner(SystemProperty.Properties.STOCK_PRICE_WARN, 0.01, 0.0, 1000.0, 0.1, "0.#%", 3);
        rightBuilder.addRow("Stock Price Warn", (Component)toAdd, "Configure the % required to warn the user if stock price changes");
        toAdd = this.setupCheckBox(SystemProperty.Properties.AUTO_PRINT_STOCK_REQ);
        rightBuilder.addRow("Auto Print Stock Requisition", (Component)toAdd, "Enable/Disable stock requisitions to automatically print at the opposite stock area that it was submitted");
        this.setLayout(new BoxLayout(this, 0));
        this.add(leftBuilder.getPanel());
        this.add(rightBuilder.getPanel());
        this.messageServerTypeJComboBox.addActionListener(this);
        this.messageServerTypeJComboBox.addItemListener(this);
    }

    private String getTwitterConfigState() {
        if (!SystemProperty.getInstance().isTwitterActive()) {
            return "(Not Active) Click to configure";
        }
        return SystemProperty.getInstance().isTwitterEnabled() ? "Configured for @" + SystemProperty.getInstance().getTwitterUserName() : "Click to configure";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MessageServerType messageServerType;
        if (e.getSource() == this.messageServerTypeJComboBox && MessageServerType.NUDGE.equals((Object)(messageServerType = (MessageServerType)this.messageServerTypeJComboBox.getSelectedItem()))) {
            this.enableNudge(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        MessageServerType deSelectedType;
        if (e.getStateChange() == 2 && MessageServerType.NUDGE.equals((Object)(deSelectedType = (MessageServerType)e.getItem()))) {
            this.enableNudge(false);
        }
    }

    private void enableNudge(boolean enable) {
        OrderMate.LOG.info("enable Nudge : " + enable);
        new NudgeHelper().enableNudge(enable);
    }
}

