/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.table;

import au.com.ordermate.util.Pair;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import officemate.components.AbstractObjectEditor;
import officemate.components.controls.IconSelectionPanel;
import ordermate.database.misc.Course;
import ordermate.database.sales.AccountState;
import ordermate.database.tables.LogicalTableState;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.NotEmptyValidator;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Validator;

public class LogicalTableStateEditor
extends AbstractObjectEditor<LogicalTableState> {
    private IconSelectionPanel iconPanel;

    public LogicalTableStateEditor() {
        this.setupComponents();
    }

    private void setupComponents() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.getBindings().setStrategy(AutoBinding.UpdateStrategy.READ_WRITE);
        JComponent component = this.setupTextField(LogicalTableState.Properties.LABEL, 30, (Validator)new NotEmptyValidator());
        builder.addRow("Label", (Component)component, "The label of this Table State");
        component = this.setupTextField(LogicalTableState.Properties.SHORT_LABEL, 10, (Validator)new NotEmptyValidator());
        builder.addRow("Short Label", (Component)component, "An abbreviated label of this Table State");
        component = this.setupTextField(LogicalTableState.Properties.EXTERNAL_LABEL, 20);
        builder.addRow("External Label", (Component)component, "The label used when integrating with certain third party software");
        this.iconPanel = new IconSelectionPanel();
        this.iconPanel.setPredefinedList(this.getPredefinedIcons());
        this.bindTextField(this.iconPanel.getTextField(), LogicalTableState.Properties.ICON, "text");
        builder.addRow("Icon", (Component)this.iconPanel, "The icon to be used int he Graphical Table Layout");
        component = this.setupAnyColorSelector(LogicalTableState.Properties.COLOUR, true);
        builder.addRow("Colour", (Component)component, "The colour to used in the Graphical Table Layout");
        component = this.setupIntSpinner(LogicalTableState.Properties.SEQUENCE, 1, 0, null, 1, 5);
        builder.addRow("Sequence", (Component)component, "The order of one table state to another");
        component = this.setupNullableComboBox(LogicalTableState.Properties.ACCOUNT_STATE, GlazedLists.eventListOf((Object[])AccountState.values()), "None");
        builder.addRow("Account State", (Component)component, "Optionally set this default state when the account is opened or closed.");
        component = this.setupNullableComboBox(LogicalTableState.Properties.COURSE, GlazedLists.eventList((Collection)Course.getCourses()), "None");
        builder.addRow("Call Course", (Component)component, "Calls the course when this state is set on the table with an account");
        this.add(builder.getPanel());
    }

    @Override
    public void setObject(LogicalTableState state) {
        super.setObject(state);
        this.iconPanel.updatePreview();
    }

    private List<Pair<String, String>> getPredefinedIcons() {
        String defDir = "/ordermate/images/tablestate/";
        ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>();
        this.addPair(pairs, "Red LED", "/ordermate/images/tablestate/ledred.png");
        this.addPair(pairs, "Blue LED", "/ordermate/images/tablestate/ledblue.png");
        this.addPair(pairs, "Green LED", "/ordermate/images/tablestate/ledgreen.png");
        this.addPair(pairs, "Cyan LED", "/ordermate/images/tablestate/ledlightblue.png");
        this.addPair(pairs, "Orange LED", "/ordermate/images/tablestate/ledorange.png");
        this.addPair(pairs, "Purple LED", "/ordermate/images/tablestate/ledpurple.png");
        this.addPair(pairs, "Yellow LED", "/ordermate/images/tablestate/ledyellow.png");
        this.addPair(pairs, "Heart", "/ordermate/images/tablestate/heart.png");
        this.addPair(pairs, "Star", "/ordermate/images/tablestate/star.png");
        this.addPair(pairs, "Lock", "/ordermate/images/tablestate/lock.png");
        this.addPair(pairs, "Red Cross", "/ordermate/images/tablestate/red_cross.png");
        this.addPair(pairs, "Green Tick", "/ordermate/images/tablestate/green_tick.png");
        this.addPair(pairs, "White Cross", "/ordermate/images/tablestate/white_cross.png");
        this.addPair(pairs, "Check Tick", "/ordermate/images/tablestate/checktick.png");
        this.addPair(pairs, "Clock", "/ordermate/images/tablestate/clock.png");
        this.addPair(pairs, "Identity", "/ordermate/images/tablestate/identity.png");
        this.addPair(pairs, "Green Man", "/ordermate/images/tablestate/greenman.png");
        this.addPair(pairs, "Blue Man", "/ordermate/images/tablestate/blueman.png");
        return pairs;
    }

    private void addPair(List<Pair<String, String>> pairs, String name, String path) {
        pairs.add((Pair<String, String>)new Pair((Object)name, (Object)path));
    }
}

