/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.waitermateproperty.screenlayouts;

import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTextField;
import officemate.components.AbstractObjectEditor;
import officemate.components.controls.CheckListComboBox;
import officemate.screens.setup.configuration.waitermateproperty.screenlayouts.ScreenConfigEditor;
import ordermate.database.gui.GuiConfig;
import ordermate.database.gui.GuiConfigSet;
import ordermate.database.gui.TerminalTypes;
import ordermate.database.gui.configmanager.GuiConfigManager;
import ordermate.database.gui.configmanager.WaiterMateGuiConfigManager;
import ordermate.database.hardware.Terminal;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.NotEmptyValidator;
import org.jdesktop.beansbinding.Validator;

public class ScreenLayoutStateEditor
extends AbstractObjectEditor<GuiConfigSet> {
    private JTextField labelField;
    private CheckListComboBox<Terminal> checkListTerminals;
    private ScreenConfigEditor configEditor;
    private List<Terminal> allTerminals;
    private List<GuiConfig> prevConfigs;

    public ScreenLayoutStateEditor(List<Terminal> terminals) {
        this.allTerminals = terminals;
    }

    @Override
    protected void init() {
        super.init();
        FieldPanelBuilder builder = new FieldPanelBuilder(5, 25);
        this.labelField = this.setupTextField(GuiConfigSet.Properties.LABEL, 25, (Validator)new NotEmptyValidator());
        builder.addRow("Set Name: ", (Component)this.labelField);
        this.checkListTerminals = new CheckListComboBox(new ArrayList());
        this.checkListTerminals.getComboBox().setName(GuiConfigSet.Properties.TERMINALS.getName());
        builder.addRow("Terminals: ", (Component)this.checkListTerminals.getComboBox());
        builder.addSeparator("Screen Configuration");
        JPanel toSet = new JPanel(new BorderLayout());
        toSet.add((Component)builder.getPanel(), "North");
        this.configEditor = new ScreenConfigEditor();
        this.configEditor.getTable().getColumn(0).setWidth(this.configEditor.getTable().getColumn(0).getWidth() * 2);
        toSet.add((Component)this.configEditor, "South");
        this.add(toSet);
    }

    private List<Terminal> getTerminalsToList(TerminalTypes type) {
        ArrayList<Terminal> terminals = new ArrayList<Terminal>();
        for (Terminal term : this.allTerminals) {
            if (!term.getTerminalType().equals(type.toString())) continue;
            terminals.add(term);
        }
        return terminals;
    }

    private GuiConfigManager getGuiConfigManagerToUse(TerminalTypes type) {
        return new WaiterMateGuiConfigManager();
    }

    @Override
    public void setObject(GuiConfigSet value) {
        this.configEditor.setManager(this.getGuiConfigManagerToUse(value.getTerminalType()));
        this.checkListTerminals.setModel(new EventComboBoxModel(GlazedLists.eventList(this.getTerminalsToList(value.getTerminalType()))));
        this.prevConfigs = new ArrayList<GuiConfig>();
        for (GuiConfig config : value.getGuiConfigs()) {
            this.prevConfigs.add(new GuiConfig(config));
        }
        this.configEditor.setGuiConfigList(value.getGuiConfigs());
        this.configEditor.invalidate();
        this.configEditor.repaint();
        this.checkListTerminals.setSelectedElements(value.getTerminals());
        super.setObject(value);
    }

    @Override
    public void saveObject() {
        List<GuiConfig> configs = this.configEditor.getGuiConfigList();
        for (GuiConfig config : configs) {
            config.setGuiConfigSet((GuiConfigSet)this.getObject());
        }
        ((GuiConfigSet)this.getObject()).setGuiConfigs(configs);
        ArrayList<Terminal> selectedTerminals = new ArrayList<Terminal>(this.checkListTerminals.getSelectedElements());
        for (Terminal term : this.getTerminalsToList(((GuiConfigSet)this.getObject()).getTerminalType())) {
            if (selectedTerminals.contains(term)) {
                term.setScreenLayoutSet((GuiConfigSet)this.getObject());
                continue;
            }
            if (term.getScreenLayoutSet() == null || !term.getScreenLayoutSet().equals(this.getObject())) continue;
            term.setScreenLayoutSet(GuiConfigSet.getDefaultSet((TerminalTypes)((GuiConfigSet)this.getObject()).getTerminalType()));
        }
        super.saveObject();
    }

    public List<GuiConfig> getPrevConfigs() {
        return this.prevConfigs;
    }
}

