/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.workflow;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JPanel;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.table.PersistentObjectTable;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import ordermate.database.workflow.Workflow;
import ordermate.database.workflow.WorkflowManager;
import ordermate.database.workflow.action.WorkflowActionSet;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import ordermate.services.misc.CallMethodOnClassExecutable;

public class ShowWorkflows {
    private ShowWorkflowsPanel panel;
    private EventList<Workflow> workflowsList;

    public void start() {
        this.workflowsList = new BasicEventList();
        this.refresh();
        if (this.panel == null) {
            this.panel = new ShowWorkflowsPanel();
        }
        Dialogs.getOkCancelDialogBuilder(this.panel).hideCancel().doPack().doShow();
    }

    private void refresh() {
        this.workflowsList.getReadWriteLock().readLock().lock();
        this.workflowsList.clear();
        this.workflowsList.addAll((Collection)PersistenceManager.getObjectList(Workflow.class, (String)Query.select(Workflow.class).equals(Workflow.Properties.PROTOTYPE, (Object)Boolean.FALSE).toString()));
        this.workflowsList.getReadWriteLock().readLock().unlock();
    }

    class ShowWorkflowsPanel
    extends JPanel
    implements ActionListener {
        private JButton restartWorkflows;
        private JButton viewWorkflow;
        private PersistentObjectTable<Workflow> table;

        private ShowWorkflowsPanel() {
            super(new BorderLayout());
            this.setupComponents();
        }

        private void setupComponents() {
            ColumnFormat[] format = new ColumnFormat[]{new PropertyColumnFormat(Workflow.Properties.ID), new EditablePropertyColumnFormat(Workflow.Properties.LABEL), new EditablePropertyColumnFormat(Workflow.Properties.DATE_CREATED), new EditablePropertyColumnFormat(Workflow.Properties.ACCOUNT), new EditablePropertyColumnFormat(Workflow.Properties.ACCOUNT_CLOSED), new EditablePropertyColumnFormat(Workflow.Properties.DONE)};
            this.table = new PersistentObjectTable(ShowWorkflows.this.workflowsList, new ColumnTableFormat(format));
            this.add(this.table, "Center");
            JPanel buttonPanel = new JPanel();
            this.add((Component)buttonPanel, "North");
            this.restartWorkflows = new JButton("Restart Workflows");
            this.restartWorkflows.addActionListener(this);
            this.viewWorkflow = new JButton("View Workflow");
            this.viewWorkflow.addActionListener(this);
            buttonPanel.add(this.viewWorkflow);
            buttonPanel.add(this.restartWorkflows);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.restartWorkflows) {
                boolean sure = Dialogs.showWarningDialog("Are you sure?", "Ensure no one is putting orders through before you restart workflows.");
                if (sure) {
                    Dialogs.showProgressDialog(new AbstractTask(){

                        public String getName() {
                            return "Restarting workflows, please be patient...";
                        }

                        protected void performTask() throws Exception {
                            CallMethodOnClassExecutable exec = new CallMethodOnClassExecutable(WorkflowManager.class.getCanonicalName(), new String[]{"getInstance", "restartManager"});
                            PersistenceManager.getServerConnection().runSync((Executable)exec);
                        }

                        protected int getTotalSubTasks() {
                            return 1;
                        }
                    });
                }
            } else if (e.getSource() == this.viewWorkflow) {
                Workflow flow = this.table.getSelectedObject();
                if (flow == null) {
                    Dialogs.showErrorDialog("No Workflow", "Select a Workflow to view");
                    return;
                }
                StringBuilder SB = new StringBuilder("Workflow " + flow.intID() + " for account " + flow.getAccount().toString() + "\r\n");
                SB.append("Created: ").append(flow.getDateCreated()).append("\r\n");
                SB.append("Completed? ").append(flow.isDone()).append(" Account closed? ").append(flow.isAccountClosed()).append(" Can close? ").append(flow.getAccount().isClosePossible());
                for (WorkflowActionSet set : flow.getActionSets()) {
                    SB.append("\r\nAction Set ").append(set.getLabel()).append(" completed? ").append(set.isCompleted());
                }
                Dialogs.showInfoDialog("Workflow " + flow.getID(), SB.toString());
            }
        }
    }
}

