/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.workflow;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.persistence.PropertiedObject;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.strategy.SaveStrategyFactory;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.PopupEditableColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import officemate.screens.setup.configuration.workflow.ShowWorkflows;
import officemate.screens.setup.configuration.workflow.WorkflowActionSetTable;
import officemate.screens.setup.configuration.workflow.WorkflowTriggerLinkEditor;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.activation.TriggerActivationStrategy;
import ordermate.database.users.AllPermissions;
import ordermate.database.workflow.Workflow;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class WorkflowSetupState
extends AbstractEditableTableState<Workflow> {
    private EventList<AbstractTrigger> triggerList = new BasicEventList();
    private WorkflowActionSetTable actionSetSetup;

    public WorkflowSetupState() {
        super("Workflow", AllPermissions.PRINTING_OPTIONS, "Add, edit and remove workflows from the system.");
        this.setSaveStrategy(SaveStrategyFactory.getInstantSaveStrategy());
        this.addAction((Action)new BasicAction("View Workflows"){

            public void actionPerformed(ActionEvent e) {
                WorkflowSetupState.this.showWorkflows();
            }
        });
    }

    @Override
    protected ObjectEditor<Workflow> createObjectEditor() {
        return null;
    }

    @Override
    protected OfficeMateObjectSearch<Workflow> createSearchPanelFactory() {
        PropertySearcher<Workflow> searcher = new PropertySearcher<Workflow>(Workflow.class){

            protected ObjectQuery getBaseQuery() {
                return Query.select(Workflow.class).equals(Workflow.Properties.PROTOTYPE, (Object)"1");
            }
        };
        ObjectPropertySearch<Workflow> search = new ObjectPropertySearch<Workflow>(Workflow.class, (ObjectQuerySearcher<Workflow>)searcher, (EventList<Workflow>)new BasicEventList());
        return search;
    }

    @Override
    public String getTypeName() {
        return "Workflow";
    }

    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        this.addSelectionChangeListener(new WorkflowSelectedListener());
        this.actionSetSetup = new WorkflowActionSetTable(this);
        this.actionSetSetup.setObject(null);
        this.getCentralArea().add(this.actionSetSetup.getComponent(), "South");
    }

    @Override
    protected TableStateCentralArea<Workflow> createCentralArea() {
        EventList strategies = GlazedLists.eventListOf((Object[])new TriggerActivationStrategy[]{TriggerActivationStrategy.ALL_TRIGGERS, TriggerActivationStrategy.ANY_TRIGGERS});
        EventList states = GlazedLists.eventListOf((Object[])new SystemState[]{SystemState.ACTIVE_STATE, SystemState.INACTIVE_STATE});
        AutoCompleteComboCellEditor systemStateEditor = new AutoCompleteComboCellEditor(states);
        AutoCompleteComboCellEditor triggerActivationEditor = new AutoCompleteComboCellEditor(strategies);
        this.triggerList.addAll((Collection)AbstractTrigger.getUserLinkableTriggers());
        WorkflowTriggerLinkEditor triggerLinkEditor = new WorkflowTriggerLinkEditor((EventList)this.triggerList);
        ColumnFormat[] format = new ColumnFormat[]{new PropertyColumnFormat(Workflow.Properties.ID), new EditablePropertyColumnFormat(Workflow.Properties.LABEL), new EditablePropertyColumnFormat(Workflow.Properties.SEQUENCE), new EditablePropertyColumnFormat(Workflow.Properties.SYSTEM_STATE).setCustomEditor((TableCellEditor)((Object)systemStateEditor)), new EditablePropertyColumnFormat(Workflow.Properties.TRIGGER_ACTIVATION_STRATEGY).setCustomEditor((TableCellEditor)((Object)triggerActivationEditor)), new PopupEditableColumnFormat((PropertiedObject.Property)Workflow.Properties.TRIGGERS, triggerLinkEditor, this)};
        PersistentObjectTable<Workflow> table = new PersistentObjectTable<Workflow>(this.getObjectList(), new ColumnTableFormat(format));
        table.getTable().setName("WorkflowTable");
        return table;
    }

    @Override
    public void refresh() {
        this.triggerList.clear();
        this.triggerList.addAll((Collection)AbstractTrigger.getUserLinkableTriggers());
        super.refresh();
    }

    @Override
    protected Class<Workflow> getDisplayingType() {
        return Workflow.class;
    }

    @Override
    protected Workflow createNewObject() {
        Workflow workflow = new Workflow();
        workflow.setLabel("New Workflow");
        workflow.setPrototype(true);
        workflow.setSequence(1);
        workflow.addTrigger((AbstractTrigger)AbstractTrigger.getDefaultTriggerIfExists());
        return workflow;
    }

    void showWorkflows() {
        new ShowWorkflows().start();
    }

    class WorkflowSelectedListener
    implements ListSelectionListener {
        WorkflowSelectedListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                WorkflowSetupState.this.actionSetSetup.setObject(WorkflowSetupState.this.getCentralArea().getSelectedObject());
            }
        }
    }
}

