/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.workflow.action;

import ca.odell.glazedlists.BasicEventList;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableListObjectEditor;
import officemate.screens.setup.configuration.workflow.action.WorkflowActionEditingPanel;
import officemate.screens.setup.configuration.workflow.action.WorkflowActionPanelFactory;
import officemate.screens.setup.configuration.workflow.action.WorkflowActionTableFormat;
import ordermate.OrderMate;
import ordermate.database.workflow.action.WorkflowAction;
import ordermate.database.workflow.action.WorkflowActionFactory;
import ordermate.database.workflow.action.WorkflowActionSet;
import ordermate.database.workflow.action.WorkflowActionType;
import ordermate.database.workflow.action.condition.WorkflowConditionType;

public class WorkflowActionTable
extends TableListObjectEditor<WorkflowActionSet, WorkflowAction> {
    private WorkflowActionPanelFactory panelFactory = new WorkflowActionPanelFactory();
    private WorkflowActionEditingPanel editingPanel;
    private JPanel holder = new JPanel();

    public WorkflowActionTable() {
        super(new PersistentObjectTable(new BasicEventList(), new WorkflowActionTableFormat()));
        this.holder.setPreferredSize(new Dimension(300, 200));
        this.add((Component)this.holder, "South");
    }

    @Override
    public WorkflowAction createNewObject() {
        WorkflowActionSet actionSet = (WorkflowActionSet)this.getObject();
        int selection = JOptionPane.showOptionDialog(this, "Please select a type of action.", "New Action", 2, 3, null, WorkflowActionType.values(), WorkflowConditionType.Printed);
        if (selection < 0) {
            return null;
        }
        WorkflowActionType type = WorkflowActionType.values()[selection];
        WorkflowActionFactory factory = new WorkflowActionFactory(actionSet);
        return factory.createAction(type);
    }

    @Override
    public void addObjectToParent(WorkflowAction toAdd) {
        ((WorkflowActionSet)this.getObject()).addAction(toAdd);
    }

    @Override
    public void removeSelectedElement() {
        super.removeSelectedElement();
        this.editingPanel.objectEdited.disconnect((Object)this);
        this.editingPanel = null;
        this.holder.removeAll();
        this.holder.validate();
        this.holder.repaint();
    }

    @Override
    public void removeObjectFromParent(WorkflowAction toRemove) {
        ((WorkflowActionSet)this.getObject()).removeAction(toRemove);
        this.gotObjectSelected(null);
    }

    @Override
    public Collection<WorkflowAction> getParentList() {
        return ((WorkflowActionSet)this.getObject()).getActions();
    }

    @Override
    public void saveObject() {
        if (this.editingPanel != null && this.editingPanel.getObject() != null) {
            this.editingPanel.saveObject();
        }
        super.saveObject();
    }

    @Override
    public void gotObjectSelected(WorkflowAction action) {
        if (this.editingPanel != null) {
            if (this.editingPanel.getObject() != null) {
                try {
                    this.editingPanel.saveObject();
                }
                catch (Exception ex) {
                    OrderMate.LOG.warn("Can't save action:", (Throwable)ex);
                }
            }
            this.editingPanel.objectEdited.disconnect((Object)this);
        }
        this.editingPanel = null;
        this.holder.removeAll();
        if (action != null) {
            this.editingPanel = this.panelFactory.getPanelFor(action.getActionType());
            this.editingPanel.objectEdited.connect((Object)this, "objectEdited");
            this.editingPanel.setObject(action);
            this.holder.add(this.editingPanel);
        }
        this.holder.validate();
        this.holder.repaint();
    }

    public void objectEdited() {
        this.getObjectTable().validate();
        this.getObjectTable().repaint();
    }
}

