/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.workflow.action;

import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JComboBox;
import officemate.screens.setup.configuration.workflow.action.WorkflowActionEditingPanel;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import ordermate.database.workflow.action.WorkflowPrintAction;
import ordermate.gui.FieldPanelBuilder;

class WorkflowPrintActionEditingPanel
extends WorkflowActionEditingPanel<WorkflowPrintAction> {
    EventList printerGroups;
    private final String nullHolder = "All";
    private JCheckBoxCellRenderer groupRenderer;
    private JComboBox virtualPrinterCombo;
    private JComboBox printerGroupsCombo;
    private JComboBox ktsStateCombo;

    WorkflowPrintActionEditingPanel() {
    }

    @Override
    protected void addToFieldPanel(FieldPanelBuilder builder) {
        EventList virtualPrinters = GlazedLists.eventList((Collection)VirtualPrinter.getAllPrinters());
        this.printerGroups = GlazedLists.eventList((Collection)PrinterGroup.getPrinterGroups());
        this.printerGroups.add(0, (Object)"All");
        this.virtualPrinterCombo = this.setupComboBox(WorkflowPrintAction.Properties.VIRTUAL_PRINTER, virtualPrinters);
        this.printerGroupsCombo = new JComboBox(new EventComboBoxModel(this.printerGroups));
        this.groupRenderer = JCheckBoxCellRenderer.install((JComboBox)this.printerGroupsCombo, (String)"All");
        this.ktsStateCombo = this.setupComboBox(WorkflowPrintAction.Properties.KTS_STATE, GlazedLists.eventList(KTSDocketState.getRegister().values()));
        builder.addRow("Virtual Printer", (Component)this.virtualPrinterCombo);
        builder.addRow("Printer Groups", (Component)this.printerGroupsCombo);
        builder.addRow("KTS State", (Component)this.ktsStateCombo);
    }

    @Override
    public void setObject(WorkflowPrintAction action) {
        super.setObject(action);
        this.groupRenderer.setSelectedElements((Collection)(action == null ? Collections.emptySet() : action.getPrinterGroups()));
    }

    @Override
    public void saveObject() {
        LinkedHashSet selection = this.groupRenderer.getSelectedElements();
        if (selection.contains("All")) {
            ((WorkflowPrintAction)this.getObject()).setPrinterGroups(null);
        } else {
            ((WorkflowPrintAction)this.getObject()).setPrinterGroups((Set)this.groupRenderer.getSelectedElements());
        }
        super.saveObject();
    }
}

