/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.workflow.condition;

import ca.odell.glazedlists.BasicEventList;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableListObjectEditor;
import officemate.screens.setup.configuration.workflow.condition.WorkflowConditionEditingPanel;
import officemate.screens.setup.configuration.workflow.condition.WorkflowConditionPanelFactory;
import officemate.screens.setup.configuration.workflow.condition.WorkflowConditionTableFormat;
import ordermate.database.workflow.action.WorkflowActionSet;
import ordermate.database.workflow.action.condition.WorkflowCondition;
import ordermate.database.workflow.action.condition.WorkflowConditionFactory;
import ordermate.database.workflow.action.condition.WorkflowConditionType;

public class WorkflowConditionTable
extends TableListObjectEditor<WorkflowActionSet, WorkflowCondition> {
    private WorkflowConditionPanelFactory panelFactory = new WorkflowConditionPanelFactory();
    private WorkflowConditionEditingPanel editingPanel;
    private JPanel holder = new JPanel();

    public WorkflowConditionTable() {
        super(new PersistentObjectTable(new BasicEventList(), new WorkflowConditionTableFormat()));
        this.holder.setPreferredSize(new Dimension(300, 200));
        this.add((Component)this.holder, "South");
    }

    @Override
    public WorkflowCondition createNewObject() {
        WorkflowActionSet actionSet = (WorkflowActionSet)this.getObject();
        int selection = JOptionPane.showOptionDialog(this, "Please select a type of condition.", "New Condition", 2, 3, null, WorkflowConditionType.values(), WorkflowConditionType.Printed);
        if (selection < 0) {
            return null;
        }
        WorkflowConditionType type = WorkflowConditionType.values()[selection];
        WorkflowConditionFactory factory = new WorkflowConditionFactory(actionSet);
        return factory.createCondition(type);
    }

    @Override
    public void addObjectToParent(WorkflowCondition toAdd) {
        ((WorkflowActionSet)this.getObject()).addCondition(toAdd);
    }

    @Override
    public void removeObjectFromParent(WorkflowCondition toRemove) {
        ((WorkflowActionSet)this.getObject()).removeCondition(toRemove);
    }

    @Override
    public Collection<WorkflowCondition> getParentList() {
        return ((WorkflowActionSet)this.getObject()).getConditions();
    }

    @Override
    public void saveObject() {
        if (this.editingPanel != null) {
            this.editingPanel.saveObject();
        }
        super.saveObject();
    }

    @Override
    public void gotObjectSelected(WorkflowCondition condition) {
        if (this.editingPanel != null) {
            this.editingPanel.saveObject();
            this.editingPanel.objectEdited.disconnect((Object)this);
        }
        this.editingPanel = null;
        this.holder.removeAll();
        if (condition != null) {
            this.editingPanel = this.panelFactory.getPanelFor(condition.getConditionType());
            this.editingPanel.setObject(condition);
            this.editingPanel.objectEdited.connect((Object)this, "objectEdited");
            this.holder.add(this.editingPanel);
        }
        this.holder.validate();
        this.holder.repaint();
    }

    public void objectEdited() {
        this.getObjectTable().validate();
        this.getObjectTable().repaint();
    }
}

