/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.configuration.workflow.condition;

import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.screens.setup.configuration.workflow.condition.WorkflowConditionEditingPanel;
import ordermate.database.workflow.action.condition.WorkflowConditionType;
import ordermate.database.workflow.action.condition.WorkflowTimeDueCondition;
import ordermate.gui.FieldPanelBuilder;

public class WorkflowTimeDueConditionEditingPanel
extends WorkflowConditionEditingPanel<WorkflowTimeDueCondition> {
    JComboBox signComboBox;
    JSpinner timeBeforeSpinner;

    @Override
    public WorkflowConditionType getConditionType() {
        return WorkflowConditionType.TimeDue;
    }

    @Override
    protected void createTypeEditor(FieldPanelBuilder builder) {
        this.timeBeforeSpinner = new JSpinner();
        this.timeBeforeSpinner.setName("timeBeforeSpinner");
        OfficeMateAdminGuiUtils.getInstance().standardSpinnerSetup(this.timeBeforeSpinner);
        this.timeBeforeSpinner.setModel(new SpinnerNumberModel((Number)10.0, Double.valueOf(0.0), null, (Number)0.5));
        this.signComboBox = new JComboBox();
        this.signComboBox.setName("signComboBox");
        EventComboBoxModel signModel = new EventComboBoxModel(GlazedLists.eventListOf((Object[])WhenDue.values()));
        this.signComboBox.setModel(signModel);
        this.signComboBox.setSelectedIndex(0);
        builder.addRow("Time (minutes)", (Component)this.timeBeforeSpinner, "The number of seconds since the workflow was created");
        builder.addRow("Before/After Due Time", (Component)this.signComboBox, "Whether to run before or after the Due Time");
    }

    @Override
    public void setObject(WorkflowTimeDueCondition object) {
        String test = object.getLabel();
        super.setObject(object);
        int timeBefore = object.getTimeBefore();
        WhenDue o = object.getTimeBefore() < 0 ? WhenDue.After : WhenDue.Before;
        this.signComboBox.setSelectedItem((Object)o);
        this.timeBeforeSpinner.setValue(Math.abs((double)timeBefore / 60.0));
    }

    @Override
    public void saveObject() {
        WorkflowTimeDueCondition workflowCond = (WorkflowTimeDueCondition)super.getObject();
        int sign = ((WhenDue)((Object)this.signComboBox.getSelectedItem())).equals((Object)WhenDue.After) ? -1 : 1;
        workflowCond.setTimeBefore((int)Math.floor(((Number)this.timeBeforeSpinner.getValue()).doubleValue() * 60.0 * (double)sign));
        super.saveObject();
    }

    private static enum WhenDue {
        Before,
        After;

    }
}

