/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices;

import officemate.adminkit.state.BasicOfficeMateState;
import officemate.screens.setup.devices.calleridunit.CallerIDUnitState;
import officemate.screens.setup.devices.camera.CameraState;
import officemate.screens.setup.devices.cashdrawer.CashdrawerState;
import officemate.screens.setup.devices.customerdisplay.CustomerDisplayState;
import officemate.screens.setup.devices.eftpos.EftposState;
import officemate.screens.setup.devices.kiosk.KioskState;
import officemate.screens.setup.devices.kts.KTSDocketPrinterState;
import officemate.screens.setup.devices.payoffprinter.PayoffPrinterState;
import officemate.screens.setup.devices.physicalprinter.PhysicalPrinterState;
import officemate.screens.setup.devices.poledisplay.PoleDisplayState;
import officemate.screens.setup.devices.printerlocations.PrinterLocationsState;
import officemate.screens.setup.devices.proximity.ProximityState;
import officemate.screens.setup.devices.receiptprinters.ReceiptPrinterState;
import officemate.screens.setup.devices.scales.ScalesState;
import officemate.screens.setup.devices.terminal.TerminalState;
import officemate.screens.setup.devices.virtualprinter.VirtualPrinterState;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.database.users.AllPermissions;

public class DevicesState
extends BasicOfficeMateState {
    private BasicOfficeMateState physPrinterState;
    private BasicOfficeMateState eftposState;
    private BasicOfficeMateState cameraState;
    private BasicOfficeMateState cashdrawerState;
    private BasicOfficeMateState poleState;
    private BasicOfficeMateState proxState;
    private BasicOfficeMateState virtPrinterState;
    private BasicOfficeMateState terminalState = new TerminalState();
    private BasicOfficeMateState ktsState;
    private BasicOfficeMateState scalesState;
    private BasicOfficeMateState customerDisplayState;
    private BasicOfficeMateState callerIdUnitState;
    private KioskState kioskState;

    public DevicesState() {
        super("Devices", AllPermissions.ALL_DEVICES, "Configure Devices");
        this.addSubState(this.terminalState);
        this.physPrinterState = new PhysicalPrinterState();
        this.addSubState(this.physPrinterState);
        this.virtPrinterState = new VirtualPrinterState();
        this.addSubState(this.virtPrinterState);
        this.addSubState(new PrinterLocationsState());
        this.addSubState(new PayoffPrinterState());
        this.addSubState(new ReceiptPrinterState());
        this.cashdrawerState = new CashdrawerState();
        this.addSubState(this.cashdrawerState);
        if (PersistentLicenseManager.getInstance().getBoolean(LicenseType.EftposIntegrationEnabled)) {
            this.eftposState = new EftposState();
            this.addSubState(this.eftposState);
        }
        this.cameraState = new CameraState();
        this.addSubState(this.cameraState);
        this.poleState = new PoleDisplayState();
        this.addSubState(this.poleState);
        this.proxState = new ProximityState();
        this.addSubState(this.proxState);
        this.ktsState = new KTSDocketPrinterState();
        this.addSubState(this.ktsState);
        this.scalesState = new ScalesState();
        this.addSubState(this.scalesState);
        this.customerDisplayState = new CustomerDisplayState();
        this.addSubState(this.customerDisplayState);
        this.callerIdUnitState = new CallerIDUnitState();
        this.addSubState(this.callerIdUnitState);
        this.kioskState = new KioskState();
        this.addSubState(this.kioskState);
    }

    @Override
    public boolean checkUpdate() {
        boolean checkIt;
        boolean bl = checkIt = this.cameraState.checkUpdate() || this.cashdrawerState.checkUpdate() || this.poleState.checkUpdate() || this.proxState.checkUpdate() || this.ktsState.checkUpdate();
        if (this.eftposState != null) {
            boolean bl2 = checkIt = checkIt || this.eftposState.checkUpdate();
        }
        if (checkIt) {
            SystemCurrentInfo.setUpdate((String)"Devices State Changed");
        }
        return false;
    }
}

