/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.camera;

import au.com.ordermate.gui.adminkit.ComponentUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import officemate.screens.setup.devices.DeviceEditor;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.Camera;
import ordermate.gui.binding.validators.InetAddressValidator;
import ordermate.gui.binding.validators.NotEmptyValidator;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.beansbinding.Validator;

public class CameraEditor
extends DeviceEditor<Camera> {
    private List<Terminal> wmTerminals;
    private JRadioButton serialButton;
    private JRadioButton ipButton;
    private List<JComponent> ipCompsList = new ArrayList<JComponent>();
    private JTextField ipField;
    private JSpinner portField;
    private JCheckBox clientBox;

    public CameraEditor() {
        super(false);
        this.buildIPCompsList();
    }

    @Override
    protected void addHeaderComponents() {
        super.addHeaderComponents();
        this.addCommonComponents();
    }

    @Override
    protected void addFooterComponents() {
        super.addFooterComponents();
        this.addIPComponents();
    }

    @Override
    protected void addMainComponents() {
        this.builder.addSeparator("Serial Settings");
        super.addMainComponents();
    }

    private void buildIPCompsList() {
        this.ipCompsList.add(this.ipField);
        this.ipCompsList.add(this.portField);
        this.ipCompsList.add(this.clientBox);
    }

    private void addCommonComponents() {
        this.builder.addSeparator("Camera Type");
        ButtonGroup typeGroup = new ButtonGroup();
        this.serialButton = new JRadioButton();
        this.serialButton.setAction(new SerialAction());
        this.ipButton = new JRadioButton();
        this.ipButton.setAction(new IPAction());
        typeGroup.add(this.serialButton);
        typeGroup.add(this.ipButton);
        JPanel wrapper = new JPanel();
        wrapper.add(this.serialButton);
        wrapper.add(this.ipButton);
        this.builder.addRow("", (Component)wrapper);
        this.builder.addSeparator("WaiterMate terminal to monitor");
        JComboBox monTerminalField = new JComboBox();
        this.wmTerminals = new ArrayList<Terminal>();
        Binding terminalBinding = this.getBindings().createJComboBoxBinding((Property)BeanProperty.create((String)"terminal"), monTerminalField, this.wmTerminals);
        ComponentUtils.setupComboBox(monTerminalField);
        terminalBinding.setValidator((Validator)new NotEmptyValidator());
        this.builder.addRow("Terminal", monTerminalField);
    }

    private void addIPComponents() {
        this.builder.addSeparator("TCP/IP Settings");
        this.ipField = new JTextField(20);
        Binding ipBinding = this.getBindings().createBinding(Camera.Properties.IP_ADDRESS, (Object)this.ipField, "text");
        ipBinding.setValidator((Validator)new InetAddressValidator(true));
        this.builder.addRow("IP Address", (Component)this.ipField);
        this.portField = new JSpinner();
        this.getBindings().createIntegerBinding(Camera.Properties.TCP_PORT, this.portField, 0, 100000, 9600);
        this.builder.addRow("TCP Port", (Component)this.portField);
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.portField, "####");
        this.portField.setEditor(editor);
        this.clientBox = new JCheckBox("Is Client?");
        this.getBindings().createBinding(Camera.Properties.CLIENT, (Object)this.clientBox, "selected");
        this.clientBox.setToolTipText("If true, the camera will need to attempt to connect to the Ordermate POS.");
        this.builder.addRow("Client or Server", (Component)this.clientBox);
        JCheckBox connectPerBox = new JCheckBox("Reconnect?");
        this.getBindings().createBinding(Camera.Properties.CONNECT_PER_LINE, (Object)connectPerBox, "selected");
        connectPerBox.setToolTipText("If true, will disconnect, then reconnect on every line break.");
        this.builder.addRow("Reconnect Per Line", (Component)connectPerBox);
    }

    @Override
    public void setObject(Camera toEdit) {
        this.wmTerminals.clear();
        this.wmTerminals.addAll(Terminal.getAllWaiterMateTerminals());
        super.setObject(toEdit);
        if (toEdit.isTcpIp()) {
            this.ipButton.doClick();
        } else {
            this.serialButton.doClick();
        }
    }

    @Override
    public void saveObject() {
        super.saveObject();
        Camera cam = (Camera)super.getObject();
        if (this.ipButton.isSelected()) {
            cam.setPort(null);
            cam.setHost(null);
        } else {
            cam.setIpAddress(null);
            cam.setTcpPort(0);
        }
    }

    private class IPAction
    extends AbstractAction {
        public IPAction() {
            super("TCP/IP");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CameraEditor.this.setCompsEnabled(CameraEditor.this.ipCompsList, true);
            CameraEditor.this.setMainComponentsEnabled(false);
            CameraEditor.this.revalidate();
        }
    }

    private class SerialAction
    extends AbstractAction {
        public SerialAction() {
            super("Serial");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CameraEditor.this.setCompsEnabled(CameraEditor.this.ipCompsList, false);
            CameraEditor.this.setMainComponentsEnabled(true);
            CameraEditor.this.revalidate();
        }
    }
}

