/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.camera;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.DefaultPropertySearcher;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.persistence.PropertiedObject;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.screens.setup.devices.DeviceTableFormat;
import officemate.screens.setup.devices.camera.CameraEditor;
import ordermate.database.hardware.physical.Camera;
import ordermate.database.hardware.physical.Device;
import ordermate.reports.table.AbstractColumnFormat;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class CameraState
extends AbstractEditableTableState<Camera> {
    public CameraState() {
        super("CCTV Cameras", null, "View, add and configure CCTV cameras.");
    }

    @Override
    public ObjectEditor<Camera> createObjectEditor() {
        return new CameraEditor();
    }

    protected String getEditHeaderText() {
        return "You can use this screen to edit a " + this.getTypeName() + ". Cameras can either be serial or TCP/IP, leave the undesired fields blank.  To save your changes click 'Ok' to forget them click 'Cancel'.";
    }

    @Override
    public String getTypeName() {
        return "Camera";
    }

    @Override
    public TableStateCentralArea<Camera> createCentralArea() {
        DeviceTableFormat format = new DeviceTableFormat();
        format.addColumn((ColumnFormat)new PropertyColumnFormat("IP Address", Camera.Properties.IP_ADDRESS));
        format.addColumn((ColumnFormat)new PropertyColumnFormat("TCP Port", Camera.Properties.TCP_PORT));
        format.prependColumn((ColumnFormat)new AbstractColumnFormat("Monitored Terminal", String.class){

            public Object resolveColumnValue(Object baseObject) {
                Camera camera = (Camera)baseObject;
                if (camera.getTerminal() != null) {
                    return camera.getTerminal().getLabel();
                }
                return null;
            }
        });
        PropertiedObject.Property[] propsToHide = new PropertiedObject.Property[]{Device.Properties.PORT_SPEED, Device.Properties.FLOW_CONTROL, Device.Properties.PORT_TYPE};
        PersistentObjectTable<Camera> gui = new PersistentObjectTable<Camera>(this.getObjectList(), format, propsToHide);
        return gui;
    }

    @Override
    public Class<Camera> getDisplayingType() {
        return Camera.class;
    }

    @Override
    public OfficeMateObjectSearch<Camera> createSearchPanelFactory() {
        return new ObjectPropertySearch<Camera>(Camera.class){

            @Override
            protected ObjectQuerySearcher<Camera> getPropertySearcher() {
                DefaultPropertySearcher searcher = (DefaultPropertySearcher)super.getPropertySearcher();
                searcher.setBaseQuery(Query.select(Camera.class).active(Camera.class));
                return searcher;
            }
        };
    }
}

