/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.cashdrawer;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.oquery.search.DefaultPropertySearcher;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import java.util.List;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.screens.setup.devices.DeviceTableFormat;
import officemate.screens.setup.devices.cashdrawer.CashDrawerCRUDValidator;
import officemate.screens.setup.devices.cashdrawer.CashdrawerEditor;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.queries.hardware.CashDrawerQueries;

public class CashdrawerState
extends AbstractEditableTableState<CashDrawer> {
    public CashdrawerState() {
        super("Cash Drawers", null, "View, add and configure cash drawers.");
    }

    @Override
    public ObjectEditor<CashDrawer> createObjectEditor() {
        CashdrawerEditor editor = new CashdrawerEditor();
        editor.gotRefresh.connect((Object)this, "gotRefresh");
        return editor;
    }

    @Override
    public String getTypeName() {
        return "Cash Drawer";
    }

    @Override
    public TableStateCentralArea<CashDrawer> createCentralArea() {
        PersistentObjectTable<CashDrawer> gui = new PersistentObjectTable<CashDrawer>(this.getObjectList(), new DeviceTableFormat());
        return gui;
    }

    @Override
    public Class<CashDrawer> getDisplayingType() {
        return CashDrawer.class;
    }

    @Override
    protected boolean isDeleteAllowed(List<CashDrawer> toDelete) {
        for (CashDrawer cd : toDelete) {
            if (new CashDrawerCRUDValidator(cd).canDelete()) continue;
            Dialogs.showErrorDialog("Cannot delete cash drawer!", "One of the selected cash drawers cannot be deleted, as ServerMate requires at least one cash drawer to be linked.");
            return false;
        }
        return true;
    }

    @Override
    public OfficeMateObjectSearch<CashDrawer> createSearchPanelFactory() {
        return new ObjectPropertySearch<CashDrawer>(CashDrawer.class){

            @Override
            protected ObjectQuerySearcher<CashDrawer> getPropertySearcher() {
                DefaultPropertySearcher searcher = (DefaultPropertySearcher)super.getPropertySearcher();
                searcher.setBaseQuery(CashDrawerQueries.ALL_ACTIVE_CASHDRAWERS);
                return searcher;
            }
        };
    }

    @Override
    protected CashDrawer createNewObject() {
        CashDrawer newDrawer = new CashDrawer();
        newDrawer.setPort("drawer.bat");
        newDrawer.setPortType("Serial");
        newDrawer.setPortSpeed(9600);
        newDrawer.setFlowControl("DtrDsr");
        newDrawer.setKickerType("Terminal");
        newDrawer.setIpPort(9100);
        return newDrawer;
    }

    void gotRefresh() {
        this.refresh();
    }
}

