/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.customerdisplay;

import au.com.ordermate.util.image.ImageHelper;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableCellEditor;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableListObjectEditor;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import officemate.components.tableformat.renderers.FileSelectCellEditor;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.misc.resource.ConfigResource;
import ordermate.database.misc.resource.ConfigResourceSet;
import ordermate.database.misc.resource.ConfigResourceType;
import ordermate.reports.table.ColumnFormat;

public class ConfigResourceEditingPanel
extends TableListObjectEditor<ConfigResourceSet, ConfigResource> {
    private final Dimension DIM = new Dimension(300, 500);
    private JPanel previewPanel = new JPanel();

    public ConfigResourceEditingPanel() {
        super(new PersistentObjectTable(new BasicEventList(), new ConfigResourceTableFormat()));
        this.add((Component)this.previewPanel, "East");
        this.previewPanel.setPreferredSize(this.DIM);
    }

    @Override
    public void gotObjectSelected(ConfigResource resource) {
        this.updatePreview(resource);
    }

    @Override
    public ConfigResource createNewObject() {
        ConfigResource resource = new ConfigResource("New Resource", ConfigResourceType.IMAGE);
        return resource;
    }

    @Override
    public void addObjectToParent(ConfigResource toAdd) {
        ((ConfigResourceSet)this.getObject()).addResource(toAdd);
    }

    @Override
    public void removeObjectFromParent(ConfigResource toRemove) {
        ((ConfigResourceSet)this.getObject()).removeResource(toRemove);
    }

    @Override
    public Collection<ConfigResource> getParentList() {
        return ((ConfigResourceSet)this.getObject()).getResources();
    }

    private void updatePreview(ConfigResource resource) {
        this.previewPanel.removeAll();
        if (resource == null) {
            return;
        }
        JLabel label = new JLabel();
        this.previewPanel.add(label);
        Image image = null;
        try {
            image = ImageIO.read(new File(resource.getResourcePath()));
            if (image != null) {
                ImageHelper helper = new ImageHelper();
                image = helper.fitImageTo(image, this.DIM.width, this.DIM.height);
                label.setIcon(new ImageIcon(image));
            } else {
                label.setText("This is not a valid image");
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("The given resource is not a valid image:" + resource.getResourcePath());
            label.setText("This image cannot be loaded.");
        }
        this.previewPanel.validate();
        this.previewPanel.repaint();
    }

    static class ConfigResourceTableFormat
    extends ColumnTableFormat {
        ConfigResourceTableFormat() {
            super(new ColumnFormat[]{new EditablePropertyColumnFormat(ConfigResource.Properties.LABEL), new EditablePropertyColumnFormat(ConfigResource.Properties.SYSTEM_STATE).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(GlazedLists.eventListOf((Object[])new SystemState[]{SystemState.ACTIVE_STATE, SystemState.INACTIVE_STATE})))), new EditablePropertyColumnFormat(ConfigResource.Properties.RESOURCE_PATH).setCustomEditor(new FileSelectCellEditor()), new EditablePropertyColumnFormat(ConfigResource.Properties.MILLI_SECONDS), new EditablePropertyColumnFormat(ConfigResource.Properties.RESOURCE_TYPE).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(GlazedLists.eventList(Arrays.asList(ConfigResourceType.IMAGE, ConfigResourceType.ANIMATION)))))});
        }
    }
}

