/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.customerdisplay;

import officemate.components.CompositeObjectEditor;
import officemate.screens.setup.devices.customerdisplay.ConfigResourceEditingPanel;
import officemate.screens.setup.devices.customerdisplay.CustomerDisplayFontEditor;
import officemate.screens.setup.devices.customerdisplay.CustomerDisplayGeneralEditor;
import officemate.screens.setup.devices.customerdisplay.CustomerDisplayMessageEditor;
import ordermate.database.misc.customerdisplay.AbstractCustomerDisplay;

public class CustomerDisplayEditor
extends CompositeObjectEditor<AbstractCustomerDisplay> {
    private CustomerDisplayGeneralEditor generalEditor;
    private ConfigResourceEditingPanel advertPanel;
    private ConfigResourceEditingPanel bannerPanel;
    private ConfigResourceEditingPanel orderPanel;
    private ConfigResourceEditingPanel internalPanel;
    private CustomerDisplayMessageEditor messageEditor;
    private CustomerDisplayFontEditor fontEditor;

    public CustomerDisplayEditor() {
        this.setupComponents();
    }

    @Override
    public void setObject(AbstractCustomerDisplay display) {
        if (display != null) {
            this.advertPanel.setObject(display.getAdvertisementSet());
            this.bannerPanel.setObject(display.getBannerSet());
            this.orderPanel.setObject(display.getOrderSet());
            this.internalPanel.setObject(display.getResourceSet());
            this.messageEditor.setObject(display);
            this.fontEditor.setObject(display);
            this.generalEditor.setObject(display);
        }
        super.setObject(display);
    }

    @Override
    public void saveObject() {
        this.generalEditor.saveObject();
        this.bannerPanel.saveObject();
        this.advertPanel.saveObject();
        this.orderPanel.saveObject();
        this.internalPanel.saveObject();
        this.messageEditor.saveObject();
        this.fontEditor.saveObject();
        super.saveObject();
    }

    private void setupComponents() {
        this.generalEditor = new CustomerDisplayGeneralEditor(this.getBindings(), this.getListener());
        this.fontEditor = new CustomerDisplayFontEditor();
        this.messageEditor = new CustomerDisplayMessageEditor();
        this.internalPanel = new ConfigResourceEditingPanel();
        this.advertPanel = new ConfigResourceEditingPanel();
        this.bannerPanel = new ConfigResourceEditingPanel();
        this.orderPanel = new ConfigResourceEditingPanel();
        this.addObjectEditorTabUnsafe("General", this.generalEditor);
        this.addObjectEditorTabUnsafe("Font", this.fontEditor);
        this.addObjectEditorTabUnsafe("Messages", this.messageEditor);
        this.addObjectEditorTabUnsafe("Advertising", this.advertPanel);
        this.addObjectEditorTabUnsafe("Banner", this.bannerPanel);
        this.addObjectEditorTabUnsafe("Order", this.orderPanel);
        this.addObjectEditorTabUnsafe("Internal", this.internalPanel);
    }
}

