/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.customerdisplay;

import au.com.ordermate.persistence.PropertiedObject;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import officemate.components.AbstractObjectEditor;
import ordermate.database.gui.FontAttributes;
import ordermate.database.misc.customerdisplay.AbstractCustomerDisplay;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.FontAttributesEditor;
import org.jdesktop.beansbinding.Binding;

class CustomerDisplayFontEditor
extends AbstractObjectEditor<AbstractCustomerDisplay> {
    private Map<PropertiedObject.Property, Binding> controls = new HashMap<PropertiedObject.Property, Binding>();
    private JPanel panel;

    CustomerDisplayFontEditor() {
    }

    @Override
    public void setObject(AbstractCustomerDisplay display) {
        if (this.panel != null) {
            this.remove(this.panel);
            for (PropertiedObject.Property key : this.controls.keySet()) {
                Binding binding = this.controls.get(key);
                this.getBindings().removeBinding(key, binding);
            }
        }
        this.controls.clear();
        List fontProps = display.getFontProperties();
        FieldPanelBuilder fontBuilder = new FieldPanelBuilder();
        for (PropertiedObject.Property nextAtt : fontProps) {
            String label = nextAtt.getUserVisibleLabel();
            label = label.substring(0, label.indexOf("Attribute"));
            fontBuilder.addRow(label, (Component)this.makeFontControl((PropertiedObject.Property<FontAttributes>)nextAtt, label));
        }
        this.panel = fontBuilder.getPanel();
        this.add(this.panel);
        super.setObject(display);
    }

    private JComponent makeFontControl(PropertiedObject.Property<FontAttributes> prop, String tipSuffix) {
        FontAttributesEditor comp = new FontAttributesEditor();
        this.controls.put(prop, this.getBindings().createBinding(prop, (Object)comp, "attributes"));
        comp.setToolTipText("Sets the font size, in points, for " + tipSuffix);
        comp.setSizeIconsAndText(null, "+", null, "-");
        return comp;
    }
}

