/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.customerdisplay;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.setup.devices.customerdisplay.CustomerDisplayEditor;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.customerdisplay.AbstractCustomerDisplay;
import ordermate.database.misc.customerdisplay.CustomerDisplayType;
import ordermate.database.misc.customerdisplay.OrderCustomerDisplay;
import ordermate.database.misc.customerdisplay.QAndACustomerDisplay;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class CustomerDisplayState
extends AbstractEditableTableState<AbstractCustomerDisplay> {
    public CustomerDisplayState() {
        super("Customer Display", null, "Do Customer Display thing.");
    }

    @Override
    protected ObjectEditor<AbstractCustomerDisplay> createObjectEditor() {
        return new CustomerDisplayEditor();
    }

    @Override
    public String getTypeName() {
        return "Customer Display";
    }

    @Override
    protected TableStateCentralArea<AbstractCustomerDisplay> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(AbstractCustomerDisplay.Properties.TERMINAL), new PropertyColumnFormat(AbstractCustomerDisplay.Properties.DEFAULT_DEVICE), new PropertyColumnFormat(AbstractCustomerDisplay.Properties.SYSTEM_STATE)});
        PersistentObjectTable<AbstractCustomerDisplay> mainTable = new PersistentObjectTable<AbstractCustomerDisplay>(this.getObjectList(), format);
        return mainTable;
    }

    @Override
    protected Class<AbstractCustomerDisplay> getDisplayingType() {
        return AbstractCustomerDisplay.class;
    }

    @Override
    protected AbstractCustomerDisplay createNewObject() {
        CustomerDisplayType displayType = (CustomerDisplayType)Dialogs.showOptionDialog("Select Type", "Please select what type of display:", Arrays.asList(CustomerDisplayType.Order, CustomerDisplayType.QAndA));
        if (displayType == null) {
            return null;
        }
        ArrayList<Terminal> lonelyTerminals = new ArrayList<Terminal>();
        for (Terminal nextTerminal : Terminal.getAllWaiterMateTerminals()) {
            List displays = PersistenceManager.getObjectList(AbstractCustomerDisplay.class, (String)Query.select(AbstractCustomerDisplay.class).equals(AbstractCustomerDisplay.Properties.TERMINAL, (Object)nextTerminal).toString(), null);
            boolean foundType = false;
            for (AbstractCustomerDisplay display : displays) {
                if (!displayType.equals((Object)display.getDisplayType())) continue;
                foundType = true;
            }
            if (foundType) continue;
            lonelyTerminals.add(nextTerminal);
        }
        if (lonelyTerminals.isEmpty()) {
            Dialogs.showInfoDialog("No Terminals Available", "There are no Waitermate Terminals without Customer Displays.");
        } else {
            Object selection = Dialogs.showOptionDialog("Which Terminal", "Please Select a Waitermate Terminal", lonelyTerminals);
            if (selection != null) {
                AbstractCustomerDisplay display = this.createNewCustomerDisplay(displayType, (Terminal)selection);
                return display;
            }
        }
        return null;
    }

    private AbstractCustomerDisplay createNewCustomerDisplay(CustomerDisplayType type, Terminal terminal) {
        if (CustomerDisplayType.Order.equals((Object)type)) {
            return new OrderCustomerDisplay(terminal);
        }
        if (CustomerDisplayType.QAndA.equals((Object)type)) {
            return new QAndACustomerDisplay(terminal);
        }
        throw new IllegalArgumentException("Cannot create a customer display for type:" + type);
    }
}

