/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.kiosk.menu;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import officemate.screens.setup.devices.kiosk.menu.ComboSelectionTableModel;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.kiosk.menu.KioskMenu;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

class KioskMenuComboSelectionPanel
extends JPanel
implements ObjectEditor<KioskMenu> {
    Signal<KioskMenu, ?, ?, ?, ?> menuChanged = Signals.createSignal(KioskMenu.class, (String)"menu");
    private JTable comboSelectionTable;
    private ComboSelectionTableModel comboTableModel;
    private InventoryProfile currentProfile;
    private KioskMenu currentMenu;

    public KioskMenuComboSelectionPanel() {
        super(new BorderLayout());
        this.setupComponents();
    }

    private void setupComponents() {
        this.comboTableModel = new ComboSelectionTableModel();
        this.comboSelectionTable = new JTable(this.comboTableModel);
        this.comboTableModel.comboChanged.connect((Object)this, "gotComboChanged");
        this.comboSelectionTable.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane(this.comboSelectionTable);
        this.add((Component)scrollPane, "Center");
    }

    public void setProfile(InventoryProfile theProfile, boolean shouldUpdate) {
        if (this.currentProfile != theProfile) {
            this.currentProfile = theProfile;
            if (shouldUpdate) {
                this.updateTable();
            }
        }
    }

    public void saveObject() {
        this.currentMenu.save();
    }

    public void setObject(KioskMenu toEdit) {
        if (this.currentMenu != toEdit) {
            this.currentMenu = toEdit;
            this.comboTableModel.setKioskMenu(toEdit);
            this.updateTable();
        }
    }

    public KioskMenu getObject() {
        return this.currentMenu;
    }

    public boolean isGuiValid() {
        return true;
    }

    public JComponent getComponent() {
        return this;
    }

    public void revertObject() {
        this.currentMenu = (KioskMenu)PersistenceManager.reacquire((PersistentObjectI)this.currentMenu);
        this.updateTable();
    }

    private void updateTable() {
        this.comboTableModel.setProfileAndMenu(this.currentProfile, this.currentMenu);
    }

    public void gotMenuChanged(KioskMenu theMenu) {
        this.menuChanged.emit((Object)theMenu);
    }

    public void gotComboChanged(InventoryCombo altered) {
        this.comboSelectionTable.validate();
        this.comboSelectionTable.repaint();
        this.menuChanged.emit((Object)this.getObject());
    }
}

