/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.kiosk.menu;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import officemate.components.renderers.TreeNodeListCellRenderer;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.kiosk.menu.KioskMenu;
import ordermate.database.kiosk.menu.KioskMenuUnitPriceLevel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

@Deprecated
class KioskMenuGroupTableModel
extends AbstractTableModel {
    Signal menuChanged = Signals.createSignal(KioskMenu.class, (String)"menu");
    private List<InventoryGroup> sections;
    private InventoryProfile profile;
    private PriceLevel priceLevel;
    private KioskMenu menu;
    private InventoryGroup currentGroup;
    private Map<InventoryGroup, List<UnitPriceLevel>> groupUnitLevelMap = new HashMap<InventoryGroup, List<UnitPriceLevel>>();
    private Map<InventoryGroup, Set<KioskMenuUnitPriceLevel>> groupKioskLevelMap = new HashMap<InventoryGroup, Set<KioskMenuUnitPriceLevel>>();

    KioskMenuGroupTableModel() {
        this.sections = new ArrayList<InventoryGroup>();
    }

    Map<InventoryGroup, List<UnitPriceLevel>> getGroupUnitMap() {
        return this.groupUnitLevelMap;
    }

    Map<InventoryGroup, Set<KioskMenuUnitPriceLevel>> getGroupKioskUnitMap() {
        return this.groupKioskLevelMap;
    }

    @Override
    public String getColumnName(int col) {
        return col == 0 ? "" : "Group";
    }

    void setProfilePriceLevelAndMenu(InventoryProfile theProfile, PriceLevel theLevel, KioskMenu theMenu) {
        if (this.priceLevel != theLevel || this.profile != theProfile || this.menu != theMenu) {
            this.priceLevel = theLevel;
            this.profile = theProfile;
            this.menu = theMenu;
            this.groupUnitLevelMap.clear();
            this.groupKioskLevelMap.clear();
            this.rebuildLists();
        }
    }

    private void rebuildLists() {
        if (this.profile == null && this.priceLevel == null) {
            return;
        }
        List theGroups = this.profile.getAvailableGroups();
        this.sections = new ArrayList<InventoryGroup>();
        this.addGroups(theGroups);
        for (InventoryGroup section : this.sections) {
            this.groupUnitLevelMap.put(section, new ArrayList());
            this.groupKioskLevelMap.put(section, new HashSet());
            ObjectQuery query = Query.select(UnitPriceLevel.class).equals(UnitPriceLevel.Properties.PRICE_LEVEL, (Object)this.priceLevel).equals(InventoryItem.Properties.MENU_GROUP, (Object)section).linkUsing(UnitPriceLevel.Properties.UNIT).linkUsing(InventoryItemUnit.Properties.ITEM).active(InventoryItemUnit.class);
            this.groupUnitLevelMap.get(section).addAll(PersistenceManager.getObjectList(UnitPriceLevel.class, (String)query.toString()));
            this.updateKioskMenuForSection(section);
        }
        this.fireTableDataChanged();
    }

    private void updateKioskMenuForSection(InventoryGroup section) {
        Set<KioskMenuUnitPriceLevel> sectionSet = this.groupKioskLevelMap.get(section);
        sectionSet.clear();
        for (KioskMenuUnitPriceLevel nextLevel : this.menu.getUnitPriceLevels()) {
            if (!SystemState.ACTIVE_STATE.equals((Object)nextLevel.getSystemState()) || !section.equals((Object)nextLevel.getUnitPriceLevel().getUnit().getItem().getMenuGroup())) continue;
            sectionSet.add(nextLevel);
        }
    }

    private boolean menuContainsAll(InventoryGroup theGroup) {
        return this.groupUnitLevelMap.get(theGroup).size() == this.groupKioskLevelMap.get(theGroup).size();
    }

    private boolean menuContainsSome(InventoryGroup theGroup) {
        if (!this.groupKioskLevelMap.containsKey(theGroup)) {
            return false;
        }
        return this.groupKioskLevelMap.get(theGroup).size() > 0;
    }

    private Containment getContainment(InventoryGroup theGroup) {
        if (this.menuContainsSome(theGroup)) {
            if (this.menuContainsAll(theGroup)) {
                return Containment.ALL;
            }
            return Containment.SOME;
        }
        return Containment.NONE;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0;
    }

    private void addGroups(List<InventoryGroup> theGroups) {
        for (InventoryGroup theGroup : theGroups) {
            this.sections.add(theGroup);
            this.addGroups(theGroup.getAvailableSubGroups());
        }
    }

    TableCellEditor createContainmentEditor() {
        return new SelectableSectionListCellEditor();
    }

    TableCellRenderer createContainmentRenderer() {
        return new SelectableSectionListCellRenderer();
    }

    TableCellRenderer createRenderer() {
        return new WrappingInventoryGroupCellRenderer();
    }

    @Override
    public int getRowCount() {
        return this.sections.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        InventoryGroup group = this.getGroupAt(rowIndex);
        if (columnIndex == 0) {
            return this.getContainment(group);
        }
        return group;
    }

    public InventoryGroup getGroupAt(int row) {
        if (row >= 0 && row < this.sections.size()) {
            return this.sections.get(row);
        }
        return null;
    }

    private void selectAllFromGroup() {
        if (this.currentGroup != null) {
            List<UnitPriceLevel> levels = this.groupUnitLevelMap.get(this.currentGroup);
            for (UnitPriceLevel level : levels) {
                this.menu.addUnitPriceLevel(level);
            }
            this.menuChanged.emit((Object)this.menu);
            this.updateKioskMenuForSection(this.currentGroup);
        }
    }

    private void selectNoneFromGroup() {
        if (this.currentGroup != null) {
            List<UnitPriceLevel> levels = this.groupUnitLevelMap.get(this.currentGroup);
            for (UnitPriceLevel level : levels) {
                this.menu.removeUnitPriceLevel(level);
            }
            this.menuChanged.emit((Object)this.menu);
            this.updateKioskMenuForSection(this.currentGroup);
        }
    }

    class SelectableSectionListCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private JCheckBox selection;
        private Containment currentValue = Containment.NONE;

        SelectableSectionListCellEditor() {
            this.selection = new JCheckBox();
            this.selection.addActionListener(this);
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentValue;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value != null) {
                KioskMenuGroupTableModel.this.currentGroup = (InventoryGroup)KioskMenuGroupTableModel.this.sections.get(row);
                if (Containment.ALL.equals(value)) {
                    this.selection.setSelected(true);
                    this.selection.setBackground(null);
                } else if (Containment.NONE.equals(value)) {
                    this.selection.setSelected(false);
                    this.selection.setBackground(null);
                } else {
                    this.selection.setSelected(true);
                    this.selection.setBackground(Color.GRAY);
                }
            }
            return this.selection;
        }

        @Override
        public boolean stopCellEditing() {
            KioskMenuGroupTableModel.this.currentGroup = null;
            return super.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            KioskMenuGroupTableModel.this.currentGroup = null;
            super.cancelCellEditing();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.selection.isSelected()) {
                KioskMenuGroupTableModel.this.selectAllFromGroup();
            } else {
                KioskMenuGroupTableModel.this.selectNoneFromGroup();
            }
            this.stopCellEditing();
        }
    }

    class SelectableSectionListCellRenderer
    implements TableCellRenderer {
        private JCheckBox selection = new JCheckBox();

        SelectableSectionListCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (Containment.ALL.equals(value)) {
                this.selection.setSelected(true);
                this.selection.setBackground(null);
            } else if (Containment.NONE.equals(value)) {
                this.selection.setSelected(false);
                this.selection.setBackground(null);
            } else {
                this.selection.setSelected(true);
                this.selection.setBackground(Color.GRAY);
            }
            return this.selection;
        }
    }

    class WrappingInventoryGroupCellRenderer
    implements TableCellRenderer {
        private TreeNodeListCellRenderer renderer = new TreeNodeListCellRenderer();
        private JList stupidDummyList = new JList();

        WrappingInventoryGroupCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.renderer.getListCellRendererComponent(this.stupidDummyList, value, row, isSelected, hasFocus);
        }
    }

    private static enum Containment {
        NONE,
        SOME,
        ALL;

    }
}

