/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.kiosk.pages.item;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.util.Collection;
import java.util.List;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableListObjectEditor;
import officemate.screens.setup.devices.kiosk.pages.item.KioskUnitPriceColumnFormat;
import ordermate.database.kiosk.menu.KioskMenu;
import ordermate.database.kiosk.menu.KioskMenuUnitPriceLevel;
import ordermate.database.kiosk.pages.AbstractOrderingKioskPage;
import ordermate.database.kiosk.pages.item.KioskPageItem;
import ordermate.database.kiosk.pages.item.KioskPageItemType;
import ordermate.database.kiosk.pages.item.KioskPageUnitPrice;

public class KioskOrderableItemsPanel
extends TableListObjectEditor<AbstractOrderingKioskPage, KioskPageItem> {
    private KioskUnitPriceColumnFormat format;

    public static KioskOrderableItemsPanel makeNew() {
        BasicEventList items = new BasicEventList();
        KioskUnitPriceColumnFormat model = new KioskUnitPriceColumnFormat();
        KioskOrderableItemsPanel panel = new KioskOrderableItemsPanel((EventList<KioskPageItem>)items, model);
        return panel;
    }

    public KioskOrderableItemsPanel(EventList<KioskPageItem> items, KioskUnitPriceColumnFormat format) {
        super(new PersistentObjectTable<KioskPageItem>(items, format));
        this.format = format;
    }

    @Override
    public void setObject(AbstractOrderingKioskPage page) {
        super.setObject(page);
        this.format.setAvailablePages(page.getPath().getPages());
    }

    @Override
    public KioskPageItem createNewObject() {
        KioskMenu menu = ((AbstractOrderingKioskPage)this.getObject()).getPath().getMenu();
        if (menu != null) {
            return this.selectItemToAdd(menu);
        }
        Dialogs.showErrorDialog("No Menu", "A KioskMenu on the Path is required");
        return null;
    }

    private KioskPageItem selectItemToAdd(KioskMenu menu) {
        List unitLevels = menu.getUnitPriceLevels();
        KioskMenuUnitPriceLevel selection = (KioskMenuUnitPriceLevel)Dialogs.showOptionDialog("Select Item", "Please select a Unit-PriceLevel to add", unitLevels);
        if (selection != null) {
            KioskPageUnitPrice item = new KioskPageUnitPrice((AbstractOrderingKioskPage)this.getObject(), selection);
            return item;
        }
        return null;
    }

    @Override
    public void addObjectToParent(KioskPageItem toAdd) {
        ((AbstractOrderingKioskPage)this.getObject()).addOrderableItem(toAdd);
    }

    @Override
    public void removeObjectFromParent(KioskPageItem toRemove) {
        ((AbstractOrderingKioskPage)this.getObject()).removeOrderableItem(toRemove);
    }

    @Override
    public Collection getParentList() {
        return ((AbstractOrderingKioskPage)this.getObject()).getPageItems(KioskPageItemType.UnitPrice);
    }
}

