/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.kts;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import officemate.components.AbstractObjectEditor;
import officemate.components.BindingGuiSupportPanel;
import officemate.components.table.PersistentObjectTable;
import officemate.screens.setup.devices.kts.KTSMilestonesTableFormat;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.hardware.physical.kts.KTSMilestone;
import ordermate.gui.binding.BindingHelper;

class KTSMilestoneEditor
extends AbstractObjectEditor<KTSDocketPrinter>
implements ActionListener {
    private JPanel holder;
    private JButton newButton;
    private JButton deleteButton;
    private PersistentObjectTable<KTSMilestone> table;
    private KTSDocketPrinter printer;
    private EventList<KTSMilestone> milestones;
    private List<KTSMilestone> deletedStonesList = new ArrayList<KTSMilestone>();

    KTSMilestoneEditor(BindingHelper<KTSDocketPrinter> bindings, BindingGuiSupportPanel.ObjectEditedListener listener) {
        super(bindings, listener);
        this.setupComponents();
    }

    private void setupComponents() {
        this.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        this.newButton = new JButton("New");
        buttonPanel.add(this.newButton);
        this.deleteButton = new JButton("Delete");
        buttonPanel.add(this.deleteButton);
        this.newButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.milestones = new BasicEventList();
        this.table = new PersistentObjectTable<KTSMilestone>(this.milestones, new KTSMilestonesTableFormat());
        this.add((Component)buttonPanel, "North");
        this.add(this.table, "Center");
    }

    public JPanel getPanel() {
        return this.holder;
    }

    @Override
    public void setObject(KTSDocketPrinter newPrinter) {
        this.printer = newPrinter;
        this.milestones.clear();
        this.deletedStonesList.clear();
        if (this.printer != null) {
            this.milestones.addAll((Collection)this.printer.getMilestones());
        }
    }

    @Override
    public void saveObject() {
        if (this.printer == null) {
            return;
        }
        ArrayList printersMilestones = new ArrayList(this.printer.getMilestones());
        for (KTSMilestone stone : this.milestones) {
            if (printersMilestones.contains(stone)) continue;
            this.printer.addMilestone(stone);
        }
        for (KTSMilestone deleted : this.deletedStonesList) {
            this.printer.removeMilestone(deleted);
        }
        this.milestones.clear();
        this.deletedStonesList.clear();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.newButton) {
            if (this.printer != null) {
                this.milestones.add((Object)new KTSMilestone(this.printer));
            }
        } else if (source == this.deleteButton) {
            KTSMilestone stone = this.table.getSelectedObject();
            this.deletedStonesList.add(stone);
            this.milestones.remove((Object)stone);
        }
    }
}

