/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.kts;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import officemate.components.AbstractObjectEditor;
import ordermate.database.hardware.physical.kts.KTSKeyMap;
import ordermate.gui.FieldPanelBuilder;

class KeyReader
extends AbstractObjectEditor<KTSKeyMap>
implements KeyListener,
ActionListener {
    private Integer value;
    private int modifier;
    private JLabel commandLabel;
    private JTextField keyStrokeField;
    private JButton clearBut;

    KeyReader() {
        this.setupComponents();
    }

    private void setupComponents() {
        this.commandLabel = new JLabel();
        this.keyStrokeField = new JTextField(20);
        this.keyStrokeField.addKeyListener(this);
        this.clearBut = new JButton("Clear");
        this.clearBut.addActionListener(this);
        FieldPanelBuilder builder = new FieldPanelBuilder();
        builder.addRow("Command:", (Component)this.commandLabel);
        builder.addRow("Key Stroke:", (Component)this.keyStrokeField);
        builder.addRow("", (Component)this.clearBut);
        this.add(builder.getPanel());
    }

    @Override
    public void setObject(KTSKeyMap map) {
        super.setObject(map);
        this.commandLabel.setText(map.getCommand().name());
        this.value = map.getKeyCode();
        this.modifier = map.getModifier();
        this.updateKeyValue(this.value, this.modifier);
    }

    @Override
    public void saveObject() {
        super.saveObject();
        ((KTSKeyMap)super.getObject()).setKeyCode(this.value);
        ((KTSKeyMap)super.getObject()).setModifier(this.modifier);
    }

    private void updateKeyValue(Integer newValue, int modifiers) {
        this.value = newValue;
        this.modifier = modifiers;
        StringBuilder SB = new StringBuilder();
        if (modifiers > 0) {
            SB.append(KeyEvent.getKeyModifiersText(modifiers)).append(" + ");
        }
        if (newValue == null) {
            SB.append("<none>");
        } else {
            SB.append(KeyEvent.getKeyText(this.value));
        }
        this.keyStrokeField.setText(SB.toString());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateKeyValue(null, 0);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        e.consume();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code != 16) {
            this.updateKeyValue(code, e.getModifiers());
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

