/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.payoffprinter;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import officemate.components.AbstractObjectEditor;
import ordermate.database.hardware.PayoffPrinter;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.NotEmptyValidator;
import org.jdesktop.beansbinding.Validator;
import org.jdesktop.swingx.combobox.ListComboBoxModel;

public class PayoffPrinterEditor
extends AbstractObjectEditor<PayoffPrinter> {
    private JComboBox terminal;
    private JComboBox virtualPrinter;
    private JComboBox unitType;
    private JTextField docketLoc;

    public PayoffPrinterEditor(EventList<String> unitTypesList) {
        this.setupComponents(unitTypesList);
    }

    private void setupComponents(EventList<String> unitTypesList) {
        this.setLayout(new BorderLayout());
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.terminal = this.setupComboBox(PayoffPrinter.Properties.TERMINAL, GlazedLists.eventList((Collection)Terminal.getAllTerminals()));
        builder.addRow("Terminal", (Component)this.terminal);
        this.virtualPrinter = this.setupComboBox(PayoffPrinter.Properties.VIRTUAL_PRINTER, (ComboBoxModel)new ListComboBoxModel(VirtualPrinter.getAllPrinters()), (Validator)new NotEmptyValidator());
        builder.addRow("Virtual Printer", (Component)this.virtualPrinter);
        this.unitType = this.setupComboBox(PayoffPrinter.Properties.UNIT_TYPE, (ComboBoxModel)new ListComboBoxModel(unitTypesList), (Validator)new NotEmptyValidator());
        builder.addRow("Unit Type", (Component)this.unitType);
        this.docketLoc = this.setupTextField(PayoffPrinter.Properties.DOCKET_LOCATION, 20);
        builder.addRow("Docket Location", (Component)this.docketLoc);
        this.add((Component)builder.getPanel(), "Center");
    }

    @Override
    public void setObject(PayoffPrinter toEdit) {
        super.setObject(toEdit);
        this.setDefaultOptionIfNull(this.terminal);
        this.setDefaultOptionIfNull(this.virtualPrinter);
        this.setDefaultOptionIfNull(this.unitType);
    }

    private void setDefaultOptionIfNull(JComboBox combo) {
        if (combo.getSelectedIndex() == -1 && combo.getModel().getSize() > 0) {
            combo.setSelectedIndex(0);
        }
    }
}

