/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.physicalprinter;

import au.com.ordermate.gui.adminkit.ComponentUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import officemate.adminkit.dialogs.Dialogs;
import officemate.screens.setup.devices.DeviceEditor;
import officemate.screens.setup.devices.physicalprinter.PhysicalPrinterPresetFactory;
import ordermate.database.hardware.physical.Device;
import ordermate.database.hardware.physical.PhysicalPrintDevice;
import ordermate.database.hardware.physical.PhysicalPrinter;
import ordermate.database.hardware.physical.PrinterCommandSet;
import ordermate.database.hardware.physical.PrinterEncoding;
import ordermate.gui.binding.validators.NotEmptyValidator;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Validator;

public class PhysicalPrinterEditor
extends DeviceEditor<PhysicalPrinter>
implements ActionListener {
    private List<PhysicalPrintDevice> backupPrinters;
    private JComboBox backupField;
    private JButton presetButton;
    private JSpinner widthField;
    private JSpinner endField;

    public PhysicalPrinterEditor() {
        super(false);
    }

    @Override
    protected void addHeaderComponents() {
        this.presetButton = new JButton("Preset Configuration...");
        this.presetButton.addActionListener(this);
        this.builder.addRow("Preset Printer", (Component)this.presetButton);
        super.addHeaderComponents();
    }

    @Override
    protected void addFooterComponents() {
        this.getPortBinding().setValidator((Validator)new NotEmptyValidator());
        JTextField ipPortField = new JTextField(7);
        Binding ipPortBinding = this.getBindings().createBinding(PhysicalPrinter.Properties.IP_PORT, (Object)ipPortField, "text");
        this.builder.addRow("IP Port", (Component)ipPortField);
        JCheckBox graphicsField = new JCheckBox();
        Binding nameBinding = this.getBindings().createBinding(PhysicalPrinter.Properties.SUPPORTS_GRAPHICS, (Object)graphicsField, "selected");
        this.builder.addRow("Supports Graphics", (Component)graphicsField);
        JComboBox commandField = new JComboBox();
        commandField.setName("commandCombo");
        ArrayList<PrinterCommandSet> commandSets = new ArrayList<PrinterCommandSet>(Arrays.asList(PrinterCommandSet.values()));
        commandSets.remove(PrinterCommandSet.Html);
        this.getBindings().createJComboBoxBinding(PhysicalPrinter.Properties.COMMAND_SET, commandField, commandSets);
        this.builder.addRow("Command Set", commandField);
        ComponentUtils.setupComboBox(commandField);
        JComboBox<Object> encodingField = new JComboBox<Object>();
        encodingField.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                PrinterEncoding enc = (PrinterEncoding)value;
                if (enc == null) {
                    enc = PrinterEncoding.Standard;
                }
                if (PrinterEncoding.Standard.equals((Object)enc)) {
                    this.setText(enc.getLabel());
                } else {
                    this.setText(enc.getLabel() + " - " + enc.getEncodingValue());
                }
                return comp;
            }
        });
        encodingField.setName("encodingCombo");
        this.getBindings().createJComboBoxBinding(PhysicalPrinter.Properties.ENCODING, encodingField, Arrays.asList(PrinterEncoding.values()));
        this.builder.addRow("Encoding", encodingField);
        ComponentUtils.setupComboBox(encodingField);
        this.widthField = new JSpinner();
        Binding widthBinding = this.getBindings().createIntegerBinding(PhysicalPrinter.Properties.WIDTH, this.widthField, 10, 500, 40);
        this.builder.addRow("Width", (Component)this.widthField, "Character width of the printer.");
        this.endField = new JSpinner();
        Binding endFieldBinding = this.getBindings().createIntegerBinding(PhysicalPrinter.Properties.LINES_AT_END, this.endField, 1, 50, 3);
        this.builder.addRow("End Lines", (Component)this.endField, "Number of lines added to the end of each docket.");
        this.backupField = new JComboBox();
        this.backupPrinters = new ArrayList<PhysicalPrintDevice>();
        this.getBindings().createJComboBoxBinding(PhysicalPrintDevice.Properties.BACKUP_PRINTER, this.backupField, this.backupPrinters);
        this.builder.addRow("Backup Printer", (Component)this.backupField, "IF this printer stops working dockets will be printed on the backup printer.");
        ComponentUtils.setupComboBox((JComboBox)this.backupField);
    }

    @Override
    public void saveObject() {
        PhysicalPrinter printer = (PhysicalPrinter)this.getBindings().getObject();
        printer.setBackupPrinter((PhysicalPrintDevice)((PhysicalPrinter)this.backupField.getSelectedItem()));
        super.saveObject();
    }

    @Override
    public void setObject(PhysicalPrinter toEdit) {
        this.backupPrinters.clear();
        this.backupPrinters.addAll(PhysicalPrintDevice.getAllActivePrintDevices());
        super.setObject(toEdit);
    }

    @Override
    protected List getPortTypes() {
        List portTypes = Device.getPortTypes();
        return portTypes;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.presetButton) {
            this.doPreset();
        }
    }

    private void doPreset() {
        List<PhysicalPrinter> presetList = PhysicalPrinterPresetFactory.getAllPresets();
        PhysicalPrinter value = (PhysicalPrinter)Dialogs.showOptionDialog("Preset Printer Setup", "Please choose a standard printer configuration", presetList);
        if (value != null) {
            this.flowField.setSelectedItem(value.getFlowControl());
            this.speedCombo.setSelectedItem(value.getPortSpeed());
            this.portField.setText(value.getPort());
            this.typeField.setSelectedItem(value.getPortType());
            this.endField.setValue(value.getLinesAtEnd());
            this.widthField.setValue(value.getWidth());
        }
    }
}

