/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.physicalprinter;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.networkio.ExecuteTaskAsLocalService;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.DefaultPropertySearcher;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.simplermi.SimpleRMI;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.InetAddress;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.strategy.AuditableDeferredSaveStrategy;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import officemate.screens.setup.devices.DeviceTableFormat;
import officemate.screens.setup.devices.physicalprinter.PhysicalPrinterEditor;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.PhysicalPrintDevice;
import ordermate.database.hardware.physical.PhysicalPrinter;
import ordermate.database.hardware.physical.PrinterCommandSet;
import ordermate.database.hardware.physical.PrinterEncoding;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import ordermate.startup.RestartPrinterExecutable;

public class PhysicalPrinterState
extends AbstractEditableTableState {
    public PhysicalPrinterState() {
        super("Physical Printers", null, "View, add and configure printers.");
        AuditableDeferredSaveStrategy strategy = new AuditableDeferredSaveStrategy((Refreshable)this);
        this.setSaveStrategy(strategy);
    }

    public ObjectEditor createObjectEditor() {
        return new PhysicalPrinterEditor();
    }

    @Override
    public void gotObjectDoubleClicked(Object toEdit) {
    }

    @Override
    public String getTypeName() {
        return "Physical Printers";
    }

    @Override
    public TableStateCentralArea createCentralArea() {
        DeviceTableFormat format = new DeviceTableFormat(true);
        format.addColumn(new EditablePropertyColumnFormat("IP Port", PhysicalPrinter.Properties.IP_PORT));
        format.addColumn(new EditablePropertyColumnFormat("Graphics", PhysicalPrinter.Properties.SUPPORTS_GRAPHICS));
        format.addColumn(new EditablePropertyColumnFormat(PhysicalPrinter.Properties.COMMAND_SET).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(GlazedLists.eventListOf((Object[])PrinterCommandSet.values()), false))));
        format.addColumn((ColumnFormat)new PropertyColumnFormat(PhysicalPrinter.Properties.ENCODING).setCustomRenderer((TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (comp instanceof JLabel && value instanceof PrinterEncoding && PrinterEncoding.Standard.equals(value)) {
                    ((JLabel)comp).setText(((PrinterEncoding)value).getLabel());
                }
                return comp;
            }
        }));
        format.addColumn(new EditablePropertyColumnFormat(PhysicalPrinter.Properties.WIDTH));
        format.addColumn(new EditablePropertyColumnFormat("End Lines", PhysicalPrinter.Properties.LINES_AT_END));
        format.addColumn(new EditablePropertyColumnFormat("Backup", PhysicalPrintDevice.Properties.BACKUP_PRINTER).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(this.getObjectList(), true))));
        return new PersistentObjectTable(this.getObjectList(), format);
    }

    @Override
    public void init() {
        super.init();
        this.addSelectionDependentAction((Action)((Object)new RestartPrintersAction()));
    }

    private void restartPrinter() {
        JFrame currentFrame = GuiApp.getAppComplex().getApplicationFrame().getFrame();
        PhysicalPrinter selectedPrinter = (PhysicalPrinter)this.getCentralArea().getSelectedObject();
        try {
            if (selectedPrinter == null) {
                JOptionPane.showMessageDialog(currentFrame, "Info", "Please select a printer", 1);
                return;
            }
            Terminal terminalForPrinter = this.getTerminalForPrinter(selectedPrinter);
            RestartPrinterExecutable restartPrinterExecutable = new RestartPrinterExecutable(selectedPrinter, terminalForPrinter);
            InetAddress ipAddress = terminalForPrinter.getAddress();
            int port = terminalForPrinter.getRmiPort();
            String serviceName = "ExecuteTaskAsLocalService";
            ExecuteTaskAsLocalService executeTaskAsLocalService = (ExecuteTaskAsLocalService)SimpleRMI.getObject((InetAddress)ipAddress, (String)serviceName, (int)port);
            executeTaskAsLocalService.executeTask((Executable)restartPrinterExecutable);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            OrderMate.LOG.error(ex.getMessage(), (Throwable)ex);
            JOptionPane.showMessageDialog(currentFrame, "Restart could not be completed " + ex.getMessage());
        }
    }

    private Terminal getTerminalForPrinter(PhysicalPrinter physicalPrinter) {
        List terminals = physicalPrinter.getTerminals();
        for (Terminal terminal : terminals) {
            if (!"ACTIVE".equals(terminal.getSystemState())) continue;
            return terminal;
        }
        return Terminal.getServerMateTerminal();
    }

    @Override
    public Class getDisplayingType() {
        return PhysicalPrinter.class;
    }

    public Object createNewObject() {
        PhysicalPrinter printer = new PhysicalPrinter();
        printer.setFlowControl("DtrDsr");
        printer.setPortSpeed(9600);
        printer.setEncoding(PrinterEncoding.Standard);
        printer.setCommandSet(PrinterCommandSet.ESCPOS);
        printer.setPortType("Serial");
        return printer;
    }

    @Override
    public OfficeMateObjectSearch createSearchPanelFactory() {
        return new ObjectPropertySearch(PhysicalPrinter.class){

            protected ObjectQuerySearcher getPropertySearcher() {
                DefaultPropertySearcher searcher = (DefaultPropertySearcher)super.getPropertySearcher();
                searcher.setBaseQuery(Query.select(PhysicalPrinter.class).active(PhysicalPrinter.class));
                return searcher;
            }
        };
    }

    private class RestartPrintersAction
    extends BasicAction {
        RestartPrintersAction() {
            super("Restart Printer", (Icon)IconLoader.get((String)"/officemate/images/restart.png"), "Restart the selected printer");
        }

        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            PhysicalPrinterState.this.restartPrinter();
            this.setEnabled(true);
        }
    }
}

