/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.printerlocations;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.persistence.PropertiedObject;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.util.Collection;
import javax.swing.table.TableCellEditor;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.strategy.AuditableDeferredSaveStrategy;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import officemate.components.tableformat.renderers.AutoCompleteComboCellEditor;
import officemate.screens.setup.devices.printerlocations.PrinterLocationEditor;
import officemate.screens.setup.devices.printerlocations.PrinterLocationSearchState;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.hardware.PrinterLocation;
import ordermate.database.hardware.TerminalLocation;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.sales.AccountType;
import ordermate.reports.table.ColumnFormat;

public class PrinterLocationsState
extends AbstractEditableTableState<PrinterLocation> {
    private EventList<String> accountTypes;

    public PrinterLocationsState() {
        super("Printer Locations", null, "View, add and configure printer locations.");
        AuditableDeferredSaveStrategy strategy = new AuditableDeferredSaveStrategy((Refreshable)this);
        this.setSaveStrategy(strategy);
        this.buildAccountTypesList();
    }

    @Override
    protected ObjectEditor<PrinterLocation> createObjectEditor() {
        return new PrinterLocationEditor(this.accountTypes);
    }

    @Override
    public String getTypeName() {
        return "Printer Locations";
    }

    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        this.addSelectionDependentAction(((PersistentObjectTable)this.getCentralArea()).getEditMultipleAction());
    }

    @Override
    protected TableStateCentralArea<PrinterLocation> createCentralArea() {
        PersistentObjectTable<PrinterLocation> table = new PersistentObjectTable<PrinterLocation>(this.getObjectList(), new ColumnTableFormat(new ColumnFormat[]{new EditablePropertyColumnFormat(PrinterLocation.Properties.PRINTER_GROUP).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(GlazedLists.eventList((Collection)PrinterGroup.getPrinterGroups()), false))), new EditablePropertyColumnFormat(PrinterLocation.Properties.VIRTUAL_PRINTER).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(GlazedLists.eventList((Collection)VirtualPrinter.getAllPrinters()), false))), new EditablePropertyColumnFormat(PrinterLocation.Properties.ACCOUNT_TYPE).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(this.accountTypes, false))), new EditablePropertyColumnFormat(PrinterLocation.Properties.TERMINAL_LOCATION).setCustomEditor((TableCellEditor)((Object)new AutoCompleteComboCellEditor(GlazedLists.eventList((Collection)TerminalLocation.getTerminalLocations()), false)))}));
        table.setPropertiesToBulkExclude(new PropertiedObject.Property[0]);
        return table;
    }

    @Override
    protected Class<PrinterLocation> getDisplayingType() {
        return PrinterLocation.class;
    }

    @Override
    protected OfficeMateObjectSearch<PrinterLocation> createSearchPanelFactory() {
        return new PrinterLocationSearchState(this.accountTypes);
    }

    private void buildAccountTypesList() {
        this.accountTypes = new BasicEventList();
        this.accountTypes.add((Object)"ALL");
        for (AccountType accType : AccountType.getTypes()) {
            this.accountTypes.add((Object)accType.getType());
        }
    }
}

