/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.setup.devices.scales;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.DefaultPropertySearcher;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.screens.setup.devices.scales.ScalesColumnFormat;
import officemate.screens.setup.devices.scales.ScalesEditor;
import ordermate.OrderMate;
import ordermate.database.hardware.physical.scales.Scales;
import ordermate.integration.scales.pie.WedderburnExporter;

public class ScalesState
extends AbstractEditableTableState<Scales> {
    private Action exportWedderburnCsv = new ExportWedderburnCsv();

    public ScalesState() {
        super("Scales", null, "Add, view, modify and delete integrated scales.");
        this.addAction(this.exportWedderburnCsv);
    }

    @Override
    protected TableStateCentralArea<Scales> createCentralArea() {
        PersistentObjectTable<Scales> table = new PersistentObjectTable<Scales>(this.getObjectList(), new ScalesColumnFormat());
        return table;
    }

    @Override
    public OfficeMateObjectSearch<Scales> createSearchPanelFactory() {
        return new ObjectPropertySearch<Scales>(Scales.class){

            @Override
            protected ObjectQuerySearcher<Scales> getPropertySearcher() {
                DefaultPropertySearcher searcher = (DefaultPropertySearcher)super.getPropertySearcher();
                searcher.setBaseQuery(Query.select(Scales.class));
                return searcher;
            }
        };
    }

    @Override
    protected Class<Scales> getDisplayingType() {
        return Scales.class;
    }

    @Override
    protected ObjectEditor<Scales> createObjectEditor() {
        return new ScalesEditor();
    }

    @Override
    public String getTypeName() {
        return "Scales";
    }

    @Override
    protected Scales createNewObject() {
        Scales scales = new Scales();
        scales.setPortSpeed(9600);
        scales.setPortType("Serial");
        scales.setFlowControl("None");
        return scales;
    }

    static class ExportWedderburnCsv
    extends AbstractAction {
        static final String DEF_STARTING_DIR = "C:\\Program Files\\Wedderburn\\SAM\\appinout\\";
        static final String ALT_STARTING_DIR = "C:\\Program Files (x86)\\Wedderburn\\SAM\\appinout\\";

        ExportWedderburnCsv() {
            super("Export To Wedderburn", IconLoader.get((String)"/ordermate/images/exportMissing.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(new FileNameExtensionFilter("CSV Files", "csv"));
            File startingDir = new File(DEF_STARTING_DIR);
            if (!startingDir.exists() && !(startingDir = new File(ALT_STARTING_DIR)).exists()) {
                startingDir = null;
            }
            if (startingDir != null) {
                startingDir = new File(startingDir.getAbsolutePath() + "\\import.csv");
                chooser.setSelectedFile(startingDir);
            }
            File file = null;
            if (chooser.showSaveDialog(null) != 0) {
                return;
            }
            try {
                file = chooser.getSelectedFile();
                if (!file.getName().contains(".")) {
                    file = new File(file.getAbsolutePath() + ".csv");
                }
                file.getParentFile().mkdirs();
                if (!file.exists()) {
                    file.createNewFile();
                }
                WedderburnExporter exporter = new WedderburnExporter();
                String toWrite = exporter.performExport();
                StringUtils.writeTextToFile((File)file, (String)toWrite);
                Dialogs.showInfoDialog("Export Done!", "The Wedderburn compatible CSV has been written.");
            }
            catch (Exception ex) {
                Dialogs.showErrorDialog("Cannot Export", "There was a problem exporting the Wedderburn CSV");
                OrderMate.LOG.error("Cannot export wedderburn csv", (Throwable)ex);
            }
            this.setEnabled(true);
        }
    }
}

